/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import io.trino.cli.TestAlignedTablePrinter;
import io.trino.cli.VerticalRecordPrinter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVerticalRecordPrinter {
    @Test
    public void testVerticalPrinting() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"last", (Object)"quantity");
        VerticalRecordPrinter printer = new VerticalRecordPrinter((List)fieldNames, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello", "world", 123), TestAlignedTablePrinter.row("a", null, 4.5), TestAlignedTablePrinter.row("some long\ntext that\ndoes not\nfit on\none line", "more\ntext", 4567), TestAlignedTablePrinter.row("bye", "done", -15)), true);
        printer.finish();
        String expected = "-[ RECORD 1 ]-------\nfirst    | hello\nlast     | world\nquantity | 123\n-[ RECORD 2 ]-------\nfirst    | a\nlast     | NULL\nquantity | 4.5\n-[ RECORD 3 ]-------\nfirst    | some long\n         | text that\n         | does not\n         | fit on\n         | one line\nlast     | more\n         | text\nquantity | 4567\n-[ RECORD 4 ]-------\nfirst    | bye\nlast     | done\nquantity | -15\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testVerticalShortName() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"a");
        VerticalRecordPrinter printer = new VerticalRecordPrinter((List)fieldNames, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("x")), true);
        printer.finish();
        String expected = "-[ RECORD 1 ]\na | x\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testVerticalLongName() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"shippriority");
        VerticalRecordPrinter printer = new VerticalRecordPrinter((List)fieldNames, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello")), true);
        printer.finish();
        String expected = "-[ RECORD 1 ]+------\nshippriority | hello\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testVerticalLongerName() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"order_priority");
        VerticalRecordPrinter printer = new VerticalRecordPrinter((List)fieldNames, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello")), true);
        printer.finish();
        String expected = "-[ RECORD 1 ]--+------\norder_priority | hello\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testVerticalWideCharacterName() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"order_priority\u7f51");
        VerticalRecordPrinter printer = new VerticalRecordPrinter((List)fieldNames, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello")), true);
        printer.finish();
        String expected = "-[ RECORD 1 ]----+------\norder_priority\u7f51 | hello\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testVerticalWideCharacterValue() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"name");
        VerticalRecordPrinter printer = new VerticalRecordPrinter((List)fieldNames, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello\u7f51 bye")), true);
        printer.finish();
        String expected = "-[ RECORD 1 ]-----\nname | hello\u7f51 bye\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }

    @Test
    public void testVerticalPrintingNoRows() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"none");
        VerticalRecordPrinter printer = new VerticalRecordPrinter((List)fieldNames, (Writer)writer);
        printer.finish();
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo("(no rows)\n");
    }

    @Test
    public void testVerticalPrintingHex() throws Exception {
        StringWriter writer = new StringWriter();
        ImmutableList fieldNames = ImmutableList.of((Object)"first", (Object)"binary", (Object)"last");
        VerticalRecordPrinter printer = new VerticalRecordPrinter((List)fieldNames, (Writer)writer);
        printer.printRows(TestAlignedTablePrinter.rows(TestAlignedTablePrinter.row("hello", TestAlignedTablePrinter.bytes("hello"), "world"), TestAlignedTablePrinter.row("a", TestAlignedTablePrinter.bytes("some long text that is more than 16 bytes"), "b"), TestAlignedTablePrinter.row("cat", TestAlignedTablePrinter.bytes(""), "dog")), true);
        printer.finish();
        String expected = "-[ RECORD 1 ]-------------------------------------------\nfirst  | hello\nbinary | 68 65 6c 6c 6f\nlast   | world\n-[ RECORD 2 ]-------------------------------------------\nfirst  | a\nbinary | 73 6f 6d 65 20 6c 6f 6e 67 20 74 65 78 74 20 74\n       | 68 61 74 20 69 73 20 6d 6f 72 65 20 74 68 61 6e\n       | 20 31 36 20 62 79 74 65 73\nlast   | b\n-[ RECORD 3 ]-------------------------------------------\nfirst  | cat\nbinary | \nlast   | dog\n";
        Assertions.assertThat((String)writer.getBuffer().toString()).isEqualTo(expected);
    }
}

