/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli.lexer;

import com.google.common.collect.ImmutableSet;
import io.trino.cli.lexer.StatementSplitter;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStatementSplitter {
    @Test
    public void testSplitterIncomplete() {
        StatementSplitter splitter = new StatementSplitter(" select * FROM foo  ");
        Assertions.assertThat((List)splitter.getCompleteStatements()).isEmpty();
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo("select * FROM foo");
    }

    @Test
    public void testSplitterEmptyInput() {
        StatementSplitter splitter = new StatementSplitter("");
        Assertions.assertThat((List)splitter.getCompleteStatements()).isEmpty();
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterEmptyStatements() {
        StatementSplitter splitter = new StatementSplitter(";;;");
        Assertions.assertThat((List)splitter.getCompleteStatements()).isEmpty();
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterSingle() {
        StatementSplitter splitter = new StatementSplitter("select * from foo;");
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select * from foo")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterMultiple() {
        StatementSplitter splitter = new StatementSplitter(" select * from  foo ; select * from t; select * from ");
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select * from  foo"), TestStatementSplitter.statement("select * from t")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo("select * from");
    }

    @Test
    public void testSplitterMultipleWithEmpty() {
        StatementSplitter splitter = new StatementSplitter("; select * from  foo ; select * from t;;;select * from ");
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select * from  foo"), TestStatementSplitter.statement("select * from t")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo("select * from");
    }

    @Test
    public void testSplitterCustomDelimiters() {
        String sql = "// select * from  foo // select * from t;//select * from ";
        StatementSplitter splitter = new StatementSplitter(sql, (Set)ImmutableSet.of((Object)";", (Object)"//"));
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{new StatementSplitter.Statement("select * from  foo", "//"), new StatementSplitter.Statement("select * from t", ";")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo("select * from");
    }

    @Test
    public void testSplitterErrorBeforeComplete() {
        StatementSplitter splitter = new StatementSplitter(" select * from z# oops ; select ");
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select * from z# oops")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo("select");
    }

    @Test
    public void testSplitterErrorAfterComplete() {
        StatementSplitter splitter = new StatementSplitter("select * from foo; select z# oops ");
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select * from foo")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo("select z# oops");
    }

    @Test
    public void testSplitterWithQuotedString() {
        String sql = "select 'foo bar' x from dual";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).isEmpty();
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo(sql);
    }

    @Test
    public void testSplitterWithIncompleteQuotedString() {
        String sql = "select 'foo', 'bar";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).isEmpty();
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo(sql);
    }

    @Test
    public void testSplitterWithEscapedSingleQuote() {
        String sql = "select 'hello''world' from dual";
        StatementSplitter splitter = new StatementSplitter(sql + ";");
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(sql)});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterWithQuotedIdentifier() {
        String sql = "select \"0\"\"bar\" from dual";
        StatementSplitter splitter = new StatementSplitter(sql + ";");
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(sql)});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterWithBackquote() {
        String sql = "select  ` f``o o ` from dual";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).isEmpty();
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo(sql);
    }

    @Test
    public void testSplitterWithDigitIdentifier() {
        String sql = "select   1x  from dual";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).isEmpty();
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo(sql);
    }

    @Test
    public void testSplitterWithSingleLineComment() {
        StatementSplitter splitter = new StatementSplitter("--empty\n;-- start\nselect * -- junk\n-- hi\nfrom foo; -- done");
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("--empty"), TestStatementSplitter.statement("-- start\nselect * -- junk\n-- hi\nfrom foo")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo("-- done");
    }

    @Test
    public void testSplitterWithMultiLineComment() {
        StatementSplitter splitter = new StatementSplitter("/* empty */;/* start */ select * /* middle */ from foo; /* end */");
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("/* empty */"), TestStatementSplitter.statement("/* start */ select * /* middle */ from foo")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo("/* end */");
    }

    @Test
    public void testSplitterWithSingleLineCommentPartial() {
        String sql = "-- start\nselect * -- junk\n-- hi\nfrom foo -- done";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).isEmpty();
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo(sql);
    }

    @Test
    public void testSplitterWithMultiLineCommentPartial() {
        String sql = "/* start */ select * /* middle */ from foo /* end */";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).isEmpty();
        Assertions.assertThat((String)splitter.getPartialStatement()).isEqualTo(sql);
    }

    @Test
    public void testSplitterIncompleteSelect() {
        String sql = "select abc, ; select 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select abc,"), TestStatementSplitter.statement("select 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterIncompleteSelectAndFrom() {
        String sql = "select abc, from ; select 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select abc, from"), TestStatementSplitter.statement("select 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterIncompleteSelectWithFrom() {
        String sql = "select abc, from xxx ; select 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select abc, from xxx"), TestStatementSplitter.statement("select 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterIncompleteSelectAndWhere() {
        String sql = "select abc, from xxx where ; select 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select abc, from xxx where"), TestStatementSplitter.statement("select 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterIncompleteSelectWithWhere() {
        String sql = "select abc, from xxx where false ; select 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select abc, from xxx where false"), TestStatementSplitter.statement("select 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterIncompleteSelectWithInvalidWhere() {
        String sql = "select abc, from xxx where and false ; select 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select abc, from xxx where and false"), TestStatementSplitter.statement("select 456")});
    }

    @Test
    public void testSplitterIncompleteSelectAndFromAndWhere() {
        String sql = "select abc, from where ; select 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select abc, from where"), TestStatementSplitter.statement("select 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterSelectItemsWithoutComma() {
        String sql = "select abc xyz foo ; select 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("select abc xyz foo"), TestStatementSplitter.statement("select 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterSimpleInlineFunction() {
        String function = "WITH FUNCTION abc() RETURNS int RETURN 42 SELECT abc() FROM t";
        String sql = function + "; SELECT 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(function), TestStatementSplitter.statement("SELECT 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterSimpleInlineFunctionWithIncompleteSelect() {
        String function = "WITH FUNCTION abc() RETURNS int RETURN 42 SELECT abc(), FROM t";
        String sql = function + "; SELECT 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(function), TestStatementSplitter.statement("SELECT 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterSimpleInlineFunctionWithComments() {
        String function = "/* start */ WITH FUNCTION abc() RETURNS int /* middle */ RETURN 42 SELECT abc() FROM t /* end */";
        String sql = function + "; SELECT 456;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(function), TestStatementSplitter.statement("SELECT 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterCreateFunction() {
        String function = "CREATE FUNCTION fib(n int) RETURNS int BEGIN IF false THEN RETURN 0; END IF; RETURN 1; END";
        String sql = function + "; SELECT 123;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(function), TestStatementSplitter.statement("SELECT 123")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterCreateFunctionInvalidThen() {
        String function = "CREATE FUNCTION fib(n int) RETURNS int BEGIN IF false THEN oops; END IF; RETURN 1; END";
        String sql = function + "; SELECT 123;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(function), TestStatementSplitter.statement("SELECT 123")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterCreateFunctionInvalidReturn() {
        String function = "CREATE FUNCTION fib(n int) RETURNS int BEGIN IF false THEN oops; END IF; RETURN 1 xxx; END";
        String sql = function + "; SELECT 123;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(function), TestStatementSplitter.statement("SELECT 123")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterCreateFunctionInvalidBegin() {
        String function = "CREATE FUNCTION fib(n int) RETURNS int BEGIN xxx IF false THEN oops; END IF; RETURN 1; END";
        String sql = function + "; SELECT 123;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("CREATE FUNCTION fib(n int) RETURNS int BEGIN xxx IF false THEN oops; END IF"), TestStatementSplitter.statement("RETURN 1"), TestStatementSplitter.statement("END"), TestStatementSplitter.statement("SELECT 123")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterCreateFunctionInvalidDelimitedThen() {
        String function = "CREATE FUNCTION fib(n int) RETURNS int BEGIN IF false THEN; oops; END IF; RETURN 1; END";
        String sql = function + "; SELECT 123;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(function), TestStatementSplitter.statement("SELECT 123")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterComplexCreateFunction() {
        String function = "CREATE FUNCTION fib(n bigint)\nRETURNS bigint\nBEGIN\n  DECLARE a bigint DEFAULT 1;\n  DECLARE b bigint DEFAULT 1;\n  DECLARE c bigint;\n  IF n <= 2 THEN\n    RETURN 1;\n  END IF;\n  WHILE n > 2 DO\n    SET n = n - 1;\n    SET c = a + b;\n    SET a = b;\n    SET b = c;\n  END WHILE;\n  RETURN c;\nEND";
        String sql = function + ";\nSELECT 123;\nSELECT 456;\n";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement(function), TestStatementSplitter.statement("SELECT 123"), TestStatementSplitter.statement("SELECT 456")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testSplitterMultipleFunctions() {
        String function1 = "CREATE FUNCTION f1() RETURNS int BEGIN IF false THEN RETURN 0; END IF; RETURN 1; END";
        String function2 = "CREATE FUNCTION f2() RETURNS int BEGIN IF false THEN RETURN 0; END IF; RETURN 1; END";
        String sql = "SELECT 11;" + function1 + ";" + function2 + ";SELECT 22;" + function2 + ";SELECT 33;";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertThat((List)splitter.getCompleteStatements()).containsExactly((Object[])new StatementSplitter.Statement[]{TestStatementSplitter.statement("SELECT 11"), TestStatementSplitter.statement(function1), TestStatementSplitter.statement(function2), TestStatementSplitter.statement("SELECT 22"), TestStatementSplitter.statement(function2), TestStatementSplitter.statement("SELECT 33")});
        Assertions.assertThat((String)splitter.getPartialStatement()).isEmpty();
    }

    @Test
    public void testIsEmptyStatement() {
        Assertions.assertThat((boolean)StatementSplitter.isEmptyStatement((String)"")).isTrue();
        Assertions.assertThat((boolean)StatementSplitter.isEmptyStatement((String)" ")).isTrue();
        Assertions.assertThat((boolean)StatementSplitter.isEmptyStatement((String)"\t\n ")).isTrue();
        Assertions.assertThat((boolean)StatementSplitter.isEmptyStatement((String)"--foo\n  --what")).isTrue();
        Assertions.assertThat((boolean)StatementSplitter.isEmptyStatement((String)"/* oops */")).isTrue();
        Assertions.assertThat((boolean)StatementSplitter.isEmptyStatement((String)"x")).isFalse();
        Assertions.assertThat((boolean)StatementSplitter.isEmptyStatement((String)"select")).isFalse();
        Assertions.assertThat((boolean)StatementSplitter.isEmptyStatement((String)"123")).isFalse();
        Assertions.assertThat((boolean)StatementSplitter.isEmptyStatement((String)"z#oops")).isFalse();
    }

    @Test
    public void testSqueezeStatement() {
        String sql = "select   *  from\n foo\n  order by x ; ";
        Assertions.assertThat((String)StatementSplitter.squeezeStatement((String)sql)).isEqualTo("select * from foo order by x ;");
    }

    @Test
    public void testSqueezeStatementWithIncompleteQuotedString() {
        String sql = "select   *  from\n foo\n  where x = 'oops";
        Assertions.assertThat((String)StatementSplitter.squeezeStatement((String)sql)).isEqualTo("select * from foo where x = 'oops");
    }

    @Test
    public void testSqueezeStatementWithBackquote() {
        String sql = "select  `  f``o  o`` `   from dual";
        Assertions.assertThat((String)StatementSplitter.squeezeStatement((String)sql)).isEqualTo("select `  f``o  o`` ` from dual");
    }

    @Test
    public void testSqueezeStatementAlternateDelimiter() {
        String sql = "select   *  from\n foo\n  order by x // ";
        Assertions.assertThat((String)StatementSplitter.squeezeStatement((String)sql)).isEqualTo("select * from foo order by x //");
    }

    @Test
    public void testSqueezeStatementError() {
        String sql = "select   *  from z#oops";
        Assertions.assertThat((String)StatementSplitter.squeezeStatement((String)sql)).isEqualTo("select * from z#oops");
    }

    private static StatementSplitter.Statement statement(String value) {
        return new StatementSplitter.Statement(value, ";");
    }
}

