/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.trino.client.ClientTypeSignature;
import io.trino.client.ClientTypeSignatureParameter;
import io.trino.client.Column;
import io.trino.client.FixJsonDataUtils;
import io.trino.client.NamedClientTypeSignature;
import io.trino.client.Row;
import io.trino.client.RowFieldName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFixJsonDataUtils {
    @Test
    public void testFixData() {
        this.assertQueryResult(BigintType.BIGINT.getTypeSignature(), 1000, 1000L);
        this.assertQueryResult(IntegerType.INTEGER.getTypeSignature(), 100, 100);
        this.assertQueryResult(SmallintType.SMALLINT.getTypeSignature(), 10, (short)10);
        this.assertQueryResult(TinyintType.TINYINT.getTypeSignature(), 1, (byte)1);
        this.assertQueryResult(BooleanType.BOOLEAN.getTypeSignature(), true, true);
        this.assertQueryResult(DateType.DATE.getTypeSignature(), "2017-07-01", "2017-07-01");
        this.assertQueryResult(DecimalType.createDecimalType().getTypeSignature(), "2.15", "2.15");
        this.assertQueryResult(RealType.REAL.getTypeSignature(), 100.23456, Float.valueOf(100.23456f));
        this.assertQueryResult(DoubleType.DOUBLE.getTypeSignature(), 100.23456, 100.23456);
        this.assertQueryResult(new TypeSignature("interval day to second", new TypeSignatureParameter[0]), "INTERVAL '2' DAY", "INTERVAL '2' DAY");
        this.assertQueryResult(new TypeSignature("interval year to month", new TypeSignatureParameter[0]), "INTERVAL '3' MONTH", "INTERVAL '3' MONTH");
        this.assertQueryResult(TimestampType.TIMESTAMP_MILLIS.getTypeSignature(), "2001-08-22 03:04:05.321", "2001-08-22 03:04:05.321");
        this.assertQueryResult(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.getTypeSignature(), "2001-08-22 03:04:05.321 America/Los_Angeles", "2001-08-22 03:04:05.321 America/Los_Angeles");
        this.assertQueryResult(TimeType.TIME.getTypeSignature(), "01:02:03.456", "01:02:03.456");
        this.assertQueryResult(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.getTypeSignature(), "01:02:03.456 America/Los_Angeles", "01:02:03.456 America/Los_Angeles");
        this.assertQueryResult(VarbinaryType.VARBINARY.getTypeSignature(), "garbage", Base64.getDecoder().decode("garbage"));
        this.assertQueryResult(VarcharType.VARCHAR.getTypeSignature(), "teststring", "teststring");
        this.assertQueryResult(CharType.createCharType((long)3L).getTypeSignature(), "abc", "abc");
        this.assertQueryResult(RowType.from((List)ImmutableList.of((Object)RowType.field((String)"foo", (Type)BigintType.BIGINT), (Object)RowType.field((String)"bar", (Type)BigintType.BIGINT))).getTypeSignature(), ImmutableList.of((Object)1, (Object)2), Row.builder().addField("foo", (Object)1L).addField("bar", (Object)2L).build());
        this.assertQueryResult(TypeSignature.arrayType((TypeSignature)BigintType.BIGINT.getTypeSignature()), ImmutableList.of((Object)1, (Object)2, (Object)4), ImmutableList.of((Object)1L, (Object)2L, (Object)4L));
        this.assertQueryResult(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()), ImmutableMap.of((Object)1, (Object)3, (Object)2, (Object)4), ImmutableMap.of((Object)1L, (Object)3L, (Object)2L, (Object)4L));
        this.assertQueryResult(new TypeSignature("json", new TypeSignatureParameter[0]), "{\"json\": {\"a\": 1}}", "{\"json\": {\"a\": 1}}");
        this.assertQueryResult(new TypeSignature("ipaddress", new TypeSignatureParameter[0]), "1.2.3.4", "1.2.3.4");
        this.assertQueryResult(new TypeSignature("uuid", new TypeSignatureParameter[0]), "0397e63b-2b78-4b7b-9c87-e085fa225dd8", "0397e63b-2b78-4b7b-9c87-e085fa225dd8");
        this.assertQueryResult(new TypeSignature("Geometry", new TypeSignatureParameter[0]), "POINT (1.2 3.4)", "POINT (1.2 3.4)");
        this.assertQueryResult(TypeSignature.mapType((TypeSignature)new TypeSignature("BingTile", new TypeSignatureParameter[0]), (TypeSignature)BigintType.BIGINT.getTypeSignature()), ImmutableMap.of((Object)"BingTile{x=1, y=2, zoom_level=10}", (Object)1), ImmutableMap.of((Object)"BingTile{x=1, y=2, zoom_level=10}", (Object)1L));
    }

    private void assertQueryResult(TypeSignature type, Object data, Object expected) {
        ArrayList rows = Lists.newArrayList((Iterable)FixJsonDataUtils.fixData((List)ImmutableList.of((Object)new Column("test", type.toString(), TestFixJsonDataUtils.toClientTypeSignature(type))), (Iterable)ImmutableList.of((Object)ImmutableList.of((Object)data))));
        Assert.assertEquals((int)rows.size(), (int)1);
        Assert.assertEquals((int)((List)rows.get(0)).size(), (int)1);
        Assert.assertEquals(((List)rows.get(0)).get(0), (Object)expected);
    }

    private static ClientTypeSignature toClientTypeSignature(TypeSignature signature) {
        return new ClientTypeSignature(signature.getBase(), (List)signature.getParameters().stream().map(TestFixJsonDataUtils::toClientTypeSignatureParameter).collect(ImmutableList.toImmutableList()));
    }

    private static ClientTypeSignatureParameter toClientTypeSignatureParameter(TypeSignatureParameter parameter) {
        switch (parameter.getKind()) {
            case TYPE: {
                return ClientTypeSignatureParameter.ofType((ClientTypeSignature)TestFixJsonDataUtils.toClientTypeSignature(parameter.getTypeSignature()));
            }
            case NAMED_TYPE: {
                return ClientTypeSignatureParameter.ofNamedType((NamedClientTypeSignature)new NamedClientTypeSignature(parameter.getNamedTypeSignature().getFieldName().map(value -> new RowFieldName(value.getName())), TestFixJsonDataUtils.toClientTypeSignature(parameter.getNamedTypeSignature().getTypeSignature())));
            }
            case LONG: {
                return ClientTypeSignatureParameter.ofLong((long)parameter.getLongLiteral());
            }
        }
        throw new IllegalArgumentException("Unsupported kind: " + parameter.getKind());
    }
}

