/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import io.trino.client.IntervalYearMonth;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIntervalYearMonth {
    @Test
    public void testFormat() {
        TestIntervalYearMonth.assertMonths(0, "0-0");
        TestIntervalYearMonth.assertMonths(IntervalYearMonth.toMonths((int)0, (int)0), "0-0");
        TestIntervalYearMonth.assertMonths(3, "0-3");
        TestIntervalYearMonth.assertMonths(-3, "-0-3");
        TestIntervalYearMonth.assertMonths(IntervalYearMonth.toMonths((int)0, (int)3), "0-3");
        TestIntervalYearMonth.assertMonths(IntervalYearMonth.toMonths((int)0, (int)-3), "-0-3");
        TestIntervalYearMonth.assertMonths(28, "2-4");
        TestIntervalYearMonth.assertMonths(-28, "-2-4");
        TestIntervalYearMonth.assertMonths(IntervalYearMonth.toMonths((int)2, (int)4), "2-4");
        TestIntervalYearMonth.assertMonths(IntervalYearMonth.toMonths((int)-2, (int)-4), "-2-4");
        TestIntervalYearMonth.assertMonths(Integer.MAX_VALUE, "178956970-7");
        TestIntervalYearMonth.assertMonths(-2147483647, "-178956970-7");
        TestIntervalYearMonth.assertMonths(Integer.MIN_VALUE, "-178956970-8");
    }

    private static void assertMonths(int months, String formatted) {
        Assert.assertEquals((String)IntervalYearMonth.formatMonths((int)months), (String)formatted);
        Assert.assertEquals((int)IntervalYearMonth.parseMonths((String)formatted), (int)months);
    }

    @Test
    public void testMaxYears() {
        int years = 0xAAAAAAA;
        Assert.assertEquals((int)IntervalYearMonth.toMonths((int)years, (int)0), (int)(years * 12));
    }

    @Test
    public void testOverflow() {
        int days = 0xAAAAAAB;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalYearMonth.toMonths((int)days, (int)0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("java.lang.ArithmeticException: integer overflow");
    }
}

