/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.trino.client.NodeVersion;
import io.trino.client.ServerInfo;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestServerInfo {
    private static final JsonCodec<ServerInfo> SERVER_INFO_CODEC = JsonCodec.jsonCodec(ServerInfo.class);

    @Test
    public void testJsonRoundTrip() {
        TestServerInfo.assertJsonRoundTrip(new ServerInfo(NodeVersion.UNKNOWN, "test", true, false, Optional.of(new Duration(2.0, TimeUnit.MINUTES))));
        TestServerInfo.assertJsonRoundTrip(new ServerInfo(NodeVersion.UNKNOWN, "test", true, false, Optional.empty()));
    }

    @Test
    public void testBackwardsCompatible() {
        ServerInfo newServerInfo = new ServerInfo(NodeVersion.UNKNOWN, "test", true, false, Optional.empty());
        ServerInfo legacyServerInfo = (ServerInfo)SERVER_INFO_CODEC.fromJson("{\"nodeVersion\":{\"version\":\"<unknown>\"},\"environment\":\"test\",\"coordinator\":true}");
        Assert.assertEquals((Object)newServerInfo, (Object)legacyServerInfo);
    }

    private static void assertJsonRoundTrip(ServerInfo serverInfo) {
        String json = SERVER_INFO_CODEC.toJson((Object)serverInfo);
        ServerInfo copy = (ServerInfo)SERVER_INFO_CODEC.fromJson(json);
        Assert.assertEquals((Object)copy, (Object)serverInfo);
    }
}

