/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.external;

import com.google.common.net.MediaType;
import io.trino.client.auth.external.HttpTokenPoller;
import io.trino.client.auth.external.TokenPollResult;
import io.trino.client.auth.external.TokenPoller;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHttpTokenPoller {
    private static final String TOKEN_PATH = "/v1/authentications/sso/test/token";
    private static final Duration ONE_SECOND = Duration.ofSeconds(1L);
    private TokenPoller tokenPoller;
    private MockWebServer server;

    @BeforeMethod(alwaysRun=true)
    public void setup() throws Exception {
        this.server = new MockWebServer();
        this.server.start();
        this.tokenPoller = new HttpTokenPoller(new OkHttpClient.Builder().callTimeout(Duration.ofMillis(500L)).build());
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws IOException {
        this.server.close();
        this.server = null;
    }

    @Test
    public void testTokenReady() {
        this.server.enqueue(TestHttpTokenPoller.statusAndBody(200, TestHttpTokenPoller.jsonPair("token", "token")));
        TokenPollResult result = this.tokenPoller.pollForToken(this.tokenUri(), ONE_SECOND);
        Assertions.assertThat((String)result.getToken().token()).isEqualTo("token");
        Assertions.assertThat((int)this.server.getRequestCount()).isEqualTo(1);
    }

    @Test
    public void testTokenNotReady() {
        this.server.enqueue(TestHttpTokenPoller.statusAndBody(200, TestHttpTokenPoller.jsonPair("nextUri", this.tokenUri())));
        TokenPollResult result = this.tokenPoller.pollForToken(this.tokenUri(), ONE_SECOND);
        Assertions.assertThat((boolean)result.isPending()).isTrue();
        Assertions.assertThat((int)this.server.getRequestCount()).isEqualTo(1);
    }

    @Test
    public void testErrorResponse() {
        this.server.enqueue(TestHttpTokenPoller.statusAndBody(200, TestHttpTokenPoller.jsonPair("error", "test failure")));
        TokenPollResult result = this.tokenPoller.pollForToken(this.tokenUri(), ONE_SECOND);
        Assertions.assertThat((boolean)result.isFailed()).isTrue();
        Assertions.assertThat((String)result.getError()).contains(new CharSequence[]{"test failure"});
    }

    @Test
    public void testBadHttpStatus() {
        this.server.enqueue(new MockResponse().setResponseCode(410));
        TokenPollResult result = this.tokenPoller.pollForToken(this.tokenUri(), ONE_SECOND);
        Assertions.assertThat((boolean)result.isFailed()).isTrue();
        Assertions.assertThat((String)result.getError()).matches((CharSequence)"Request to http://.* failed: JsonResponse\\{statusCode=410, .*");
    }

    @Test
    public void testInvalidJsonBody() {
        this.server.enqueue(TestHttpTokenPoller.statusAndBody(200, TestHttpTokenPoller.jsonPair("foo", "bar")));
        TokenPollResult result = this.tokenPoller.pollForToken(this.tokenUri(), ONE_SECOND);
        Assertions.assertThat((boolean)result.isFailed()).isTrue();
        Assertions.assertThat((String)result.getError()).isEqualTo("Failed to poll for token. No fields set in response.");
    }

    @Test
    public void testInvalidNextUri() {
        this.server.enqueue(TestHttpTokenPoller.statusAndBody(200, TestHttpTokenPoller.jsonPair("nextUri", ":::")));
        TokenPollResult result = this.tokenPoller.pollForToken(this.tokenUri(), ONE_SECOND);
        Assertions.assertThat((boolean)result.isFailed()).isTrue();
        Assertions.assertThat((String)result.getError()).matches((CharSequence)"Request to http://.* failed: JsonResponse\\{statusCode=200, .*, hasValue=false} .*");
    }

    @Test
    public void testHttpStatus503() {
        for (int i = 1; i <= 100; ++i) {
            this.server.enqueue(TestHttpTokenPoller.statusAndBody(503, "Server failure #" + i));
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tokenPoller.pollForToken(this.tokenUri(), ONE_SECOND)).isInstanceOf(UncheckedIOException.class)).hasRootCauseExactlyInstanceOf(IOException.class).hasMessageFindingMatch("Request to http://.* failed: JsonResponse\\{statusCode=503,").hasMessageContaining("[Error: Server failure #");
        Assertions.assertThat((int)this.server.getRequestCount()).isGreaterThan(1);
    }

    @Test
    public void testHttpTimeout() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tokenPoller.pollForToken(this.tokenUri(), ONE_SECOND)).isInstanceOf(UncheckedIOException.class)).hasMessageEndingWith(": timeout");
    }

    @Test
    public void testTokenReceived() throws InterruptedException {
        this.server.enqueue(TestHttpTokenPoller.status(200));
        this.tokenPoller.tokenReceived(this.tokenUri());
        RecordedRequest request = this.server.takeRequest(1L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((String)request.getMethod()).isEqualTo("DELETE");
        Assertions.assertThat((Object)request.getRequestUrl()).isEqualTo((Object)HttpUrl.get((URI)this.tokenUri()));
    }

    @Test
    public void testTokenReceivedRetriesUntilHTTP_OK() {
        this.server.enqueue(TestHttpTokenPoller.status(503));
        this.server.enqueue(TestHttpTokenPoller.status(503));
        this.server.enqueue(TestHttpTokenPoller.status(503));
        this.server.enqueue(TestHttpTokenPoller.status(202));
        this.server.enqueue(TestHttpTokenPoller.status(303));
        this.server.enqueue(TestHttpTokenPoller.status(200));
        this.server.enqueue(TestHttpTokenPoller.status(200));
        this.server.enqueue(TestHttpTokenPoller.status(200));
        this.tokenPoller.tokenReceived(this.tokenUri());
        Assertions.assertThat((int)this.server.getRequestCount()).isEqualTo(6);
    }

    @Test
    public void testTokenReceivedDoesNotRetriesIndefinitely() {
        for (int i = 1; i <= 100; ++i) {
            this.server.enqueue(TestHttpTokenPoller.status(503));
        }
        this.tokenPoller.tokenReceived(this.tokenUri());
        Assertions.assertThat((int)this.server.getRequestCount()).isLessThan(100);
    }

    private URI tokenUri() {
        return URI.create("http://" + this.server.getHostName() + ":" + this.server.getPort() + TOKEN_PATH);
    }

    private static String jsonPair(String key, Object value) {
        return String.format("{\"%s\": \"%s\"}", key, value);
    }

    private static MockResponse statusAndBody(int status, String body) {
        return new MockResponse().setResponseCode(status).addHeader("Content-Type", (Object)MediaType.JSON_UTF_8).setBody(body);
    }

    private static MockResponse status(int status) {
        return new MockResponse().setResponseCode(status);
    }
}

