/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import io.trino.client.IntervalDayTime;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestIntervalDayTime {
    @Test
    public void testFormat() {
        TestIntervalDayTime.assertMillis(0L, "0 00:00:00.000");
        TestIntervalDayTime.assertMillis(1L, "0 00:00:00.001");
        TestIntervalDayTime.assertMillis(-1L, "-0 00:00:00.001");
        TestIntervalDayTime.assertMillis(IntervalDayTime.toMillis((long)12L, (long)13L, (long)45L, (long)56L, (long)789L), "12 13:45:56.789");
        TestIntervalDayTime.assertMillis(IntervalDayTime.toMillis((long)-12L, (long)-13L, (long)-45L, (long)-56L, (long)-789L), "-12 13:45:56.789");
        TestIntervalDayTime.assertMillis(Long.MAX_VALUE, "106751991167 07:12:55.807");
        TestIntervalDayTime.assertMillis(-9223372036854775807L, "-106751991167 07:12:55.807");
        TestIntervalDayTime.assertMillis(Long.MIN_VALUE, "-106751991167 07:12:55.808");
    }

    private static void assertMillis(long millis, String formatted) {
        Assert.assertEquals((String)IntervalDayTime.formatMillis((long)millis), (String)formatted);
        Assert.assertEquals((long)IntervalDayTime.parseMillis((String)formatted), (long)millis);
    }

    @Test
    public void textMaxDays() {
        long days = Long.MAX_VALUE / TimeUnit.DAYS.toMillis(1L);
        Assert.assertEquals((long)IntervalDayTime.toMillis((long)days, (long)0L, (long)0L, (long)0L, (long)0L), (long)TimeUnit.DAYS.toMillis(days));
    }

    @Test
    public void testOverflow() {
        long days = Long.MAX_VALUE / TimeUnit.DAYS.toMillis(1L) + 1L;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalDayTime.toMillis((long)days, (long)0L, (long)0L, (long)0L, (long)0L)).isInstanceOf(IllegalArgumentException.class)).hasMessage("java.lang.ArithmeticException: long overflow");
    }
}

