/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.collect.ImmutableSet;
import io.trino.client.ProtocolDetectionException;
import io.trino.client.ProtocolHeaders;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestProtocolHeaders {
    @Test
    public void testDetection() throws Exception {
        Assert.assertEquals((String)ProtocolHeaders.detectProtocol(Optional.empty(), (Set)ImmutableSet.of()).getProtocolName(), (String)"Trino");
        Assert.assertEquals((String)ProtocolHeaders.detectProtocol(Optional.of("Trino"), (Set)ImmutableSet.of((Object)"X-Trino-User")).getProtocolName(), (String)"Trino");
        Assert.assertEquals((String)ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Taco-User")).getProtocolName(), (String)"Taco");
        Assert.assertEquals((String)ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Taco-Source")).getProtocolName(), (String)"Taco");
        Assert.assertEquals((String)ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Burrito-User", (Object)"X-Burrito-Source")).getProtocolName(), (String)"Trino");
        Assertions.assertThatThrownBy(() -> ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Taco-User", (Object)"X-Trino-Source"))).isInstanceOf(ProtocolDetectionException.class);
        Assertions.assertThatThrownBy(() -> ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Trino-User", (Object)"X-Taco-User"))).isInstanceOf(ProtocolDetectionException.class);
    }
}

