/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Strings;
import io.trino.client.JsonCodec;
import io.trino.client.QueryResults;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestQueryResults {
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private static final String GOLDEN_VALUE = "{\n  \"id\" : \"20160128_214710_00012_rk68b\",\n  \"infoUri\" : \"http://localhost:54855/query.html?20160128_214710_00012_rk68b\",\n  \"columns\" : [ {\n    \"name\" : \"_col0\",\n    \"type\" : \"bigint\",\n    \"typeSignature\" : {\n      \"rawType\" : \"varchar\",\n      \"typeArguments\" : [ ],\n      \"literalArguments\" : [ ],\n      \"arguments\" : [ ]\n    }\n  } ],\n  \"data\" : [ [ %s ] ],\n  \"stats\" : {\n    \"state\" : \"FINISHED\",\n    \"queued\" : false,\n    \"scheduled\" : false,\n    \"nodes\" : 0,\n    \"totalSplits\" : 0,\n    \"queuedSplits\" : 0,\n    \"runningSplits\" : 0,\n    \"completedSplits\" : 0,\n    \"cpuTimeMillis\" : 0,\n    \"wallTimeMillis\" : 0,\n    \"queuedTimeMillis\" : 0,\n    \"elapsedTimeMillis\" : 0,\n    \"processedRows\" : 0,\n    \"processedBytes\" : 0,\n    \"peakMemoryBytes\" : 0\n  }\n}";

    @Test
    public void testCompatibility() throws JsonProcessingException {
        QueryResults results = (QueryResults)QUERY_RESULTS_CODEC.fromJson(String.format(GOLDEN_VALUE, "\"123\""));
        Assert.assertEquals((String)results.getId(), (String)"20160128_214710_00012_rk68b");
    }

    @Test
    public void testReadLongColumn() throws JsonProcessingException {
        String longString = Strings.repeat((String)"a", (int)20000001);
        QueryResults results = (QueryResults)QUERY_RESULTS_CODEC.fromJson(String.format(GOLDEN_VALUE, '\"' + longString + '\"'));
        Assert.assertEquals((String)results.getId(), (String)"20160128_214710_00012_rk68b");
    }
}

