/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.trino.client.ClientSession;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import io.trino.client.QueryResults;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.client.StatementStats;
import java.io.IOException;
import java.net.URI;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.SocketPolicy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestRetry {
    private MockWebServer server;
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);

    @BeforeEach
    public void setup() throws Exception {
        this.server = new MockWebServer();
        this.server.start();
    }

    @AfterEach
    public void teardown() throws IOException {
        this.server.close();
        this.server = null;
    }

    @Test
    public void testRetryOnBrokenStream() {
        java.time.Duration timeout = java.time.Duration.ofMillis(100L);
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).callTimeout(timeout).build();
        ClientSession session = ClientSession.builder().server(URI.create("http://" + this.server.getHostName() + ":" + this.server.getPort())).timeZone(ZoneId.of("UTC")).clientRequestTimeout(Duration.valueOf((String)"2s")).build();
        this.server.enqueue(TestRetry.statusAndBody(200, this.newQueryResults("RUNNING")));
        this.server.enqueue(TestRetry.statusAndBody(200, this.newQueryResults("FINISHED")).setSocketPolicy(SocketPolicy.DISCONNECT_DURING_RESPONSE_BODY));
        this.server.enqueue(TestRetry.statusAndBody(200, this.newQueryResults("FINISHED")));
        try (StatementClient client = StatementClientFactory.newStatementClient((OkHttpClient)httpClient, (ClientSession)session, (String)"SELECT 1", Optional.empty());){
            while (client.advance()) {
            }
            Assert.assertTrue((boolean)client.isFinished());
        }
        Assertions.assertThat((int)this.server.getRequestCount()).isEqualTo(3);
    }

    private String newQueryResults(String state) {
        String queryId = "20160128_214710_00012_rk68b";
        int numRecords = 10;
        QueryResults queryResults = new QueryResults(queryId, this.server.url("/query.html?" + queryId).uri(), null, state.equals("RUNNING") ? this.server.url(String.format("/v1/statement/%s/%s", queryId, "aa")).uri() : null, Stream.of(new Column("id", "integer", new ClientTypeSignature("integer")), new Column("name", "varchar", new ClientTypeSignature("varchar"))).collect(Collectors.toList()), IntStream.range(0, numRecords).mapToObj(index -> Stream.of(index, "a").collect(Collectors.toList())).collect(Collectors.toList()), new StatementStats(state, state.equals("QUEUED"), true, OptionalDouble.of(0.0), OptionalDouble.of(0.0), 0, 0, 0, 0, 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, null), null, (List)ImmutableList.of(), null, null);
        return QUERY_RESULTS_CODEC.toJson((Object)queryResults);
    }

    private static MockResponse statusAndBody(int status, String body) {
        return new MockResponse().setResponseCode(status).addHeader("Content-Type", (Object)MediaType.JSON_UTF_8).setBody(body);
    }
}

