/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.external;

import io.trino.client.auth.external.RedirectException;
import io.trino.client.auth.external.RedirectHandler;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;

public class MockRedirectHandler
implements RedirectHandler {
    private URI redirectedTo;
    private AtomicInteger redirectionCount = new AtomicInteger(0);
    private Duration redirectTime;

    public void redirectTo(URI uri) throws RedirectException {
        this.redirectedTo = uri;
        this.redirectionCount.incrementAndGet();
        try {
            if (this.redirectTime != null) {
                Thread.sleep(this.redirectTime.toMillis());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public URI redirectedTo() {
        return this.redirectedTo;
    }

    public int getRedirectionCount() {
        return this.redirectionCount.get();
    }

    public MockRedirectHandler sleepOnRedirect(Duration redirectTime) {
        this.redirectTime = redirectTime;
        return this;
    }
}

