/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.external;

import com.google.common.util.concurrent.Uninterruptibles;
import io.trino.client.ClientException;
import io.trino.client.auth.external.ExternalAuthentication;
import io.trino.client.auth.external.MockRedirectHandler;
import io.trino.client.auth.external.MockTokenPoller;
import io.trino.client.auth.external.RedirectHandler;
import io.trino.client.auth.external.Token;
import io.trino.client.auth.external.TokenPollResult;
import io.trino.client.auth.external.TokenPoller;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExternalAuthentication {
    private static final String AUTH_TOKEN = "authToken";
    private static final URI REDIRECT_URI = URI.create("https://redirect.uri");
    private static final URI TOKEN_URI = URI.create("https://token.uri");
    private static final Duration TIMEOUT = Duration.ofSeconds(1L);

    @Test
    public void testObtainTokenWhenTokenAlreadyExists() {
        MockRedirectHandler redirectHandler = new MockRedirectHandler();
        MockTokenPoller poller = new MockTokenPoller().withResult(TOKEN_URI, TokenPollResult.successful((Token)new Token(AUTH_TOKEN)));
        Optional token = new ExternalAuthentication(TOKEN_URI, Optional.of(REDIRECT_URI)).obtainToken(TIMEOUT, (RedirectHandler)redirectHandler, (TokenPoller)poller);
        Assertions.assertThat((URI)redirectHandler.redirectedTo()).isEqualTo((Object)REDIRECT_URI);
        Assertions.assertThat((Optional)token).map(Token::token).hasValue((Object)AUTH_TOKEN);
        Assertions.assertThat((URI)poller.tokenReceivedUri()).isEqualTo((Object)TOKEN_URI);
    }

    @Test
    public void testObtainTokenWhenTokenIsReadyAtSecondAttempt() {
        MockRedirectHandler redirectHandler = new MockRedirectHandler();
        URI nextTokenUri = TOKEN_URI.resolve("/next");
        MockTokenPoller poller = new MockTokenPoller().withResult(TOKEN_URI, TokenPollResult.pending((URI)nextTokenUri)).withResult(nextTokenUri, TokenPollResult.successful((Token)new Token(AUTH_TOKEN)));
        Optional token = new ExternalAuthentication(TOKEN_URI, Optional.of(REDIRECT_URI)).obtainToken(TIMEOUT, (RedirectHandler)redirectHandler, (TokenPoller)poller);
        Assertions.assertThat((Optional)token).map(Token::token).hasValue((Object)AUTH_TOKEN);
        Assertions.assertThat((URI)poller.tokenReceivedUri()).isEqualTo((Object)nextTokenUri);
    }

    @Test
    public void testObtainTokenWhenTokenIsNeverAvailable() {
        MockRedirectHandler redirectHandler = new MockRedirectHandler();
        TokenPoller poller = MockTokenPoller.onPoll(tokenUri -> {
            Uninterruptibles.sleepUninterruptibly((Duration)Duration.ofMillis(20L));
            return TokenPollResult.pending((URI)TOKEN_URI);
        });
        Optional token = new ExternalAuthentication(TOKEN_URI, Optional.of(REDIRECT_URI)).obtainToken(TIMEOUT, (RedirectHandler)redirectHandler, poller);
        Assertions.assertThat((Optional)token).isEmpty();
    }

    @Test
    public void testObtainTokenWhenPollingFails() {
        MockRedirectHandler redirectHandler = new MockRedirectHandler();
        MockTokenPoller poller = new MockTokenPoller().withResult(TOKEN_URI, TokenPollResult.failed((String)"error"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ExternalAuthentication(TOKEN_URI, Optional.of(REDIRECT_URI)).obtainToken(TIMEOUT, redirectHandler, poller)).isInstanceOf(ClientException.class)).hasMessage("error");
    }

    @Test
    public void testObtainTokenWhenPollingFailsWithException() {
        MockRedirectHandler redirectHandler = new MockRedirectHandler();
        TokenPoller poller = MockTokenPoller.onPoll(uri -> {
            throw new UncheckedIOException(new IOException("polling error"));
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ExternalAuthentication(TOKEN_URI, Optional.of(REDIRECT_URI)).obtainToken(TIMEOUT, redirectHandler, poller)).isInstanceOf(UncheckedIOException.class)).hasRootCauseInstanceOf(IOException.class).hasRootCauseMessage("polling error");
    }

    @Test
    public void testObtainTokenWhenNoRedirectUriHasBeenProvided() {
        MockRedirectHandler redirectHandler = new MockRedirectHandler();
        MockTokenPoller poller = new MockTokenPoller().withResult(TOKEN_URI, TokenPollResult.successful((Token)new Token(AUTH_TOKEN)));
        Optional token = new ExternalAuthentication(TOKEN_URI, Optional.empty()).obtainToken(TIMEOUT, (RedirectHandler)redirectHandler, (TokenPoller)poller);
        Assertions.assertThat((URI)redirectHandler.redirectedTo()).isNull();
        Assertions.assertThat((Optional)token).map(Token::token).hasValue((Object)AUTH_TOKEN);
    }
}

