/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.uri;

import io.trino.client.uri.ConnectionProperties;
import io.trino.client.uri.PropertyName;
import io.trino.client.uri.TrinoUri;
import java.net.URI;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestTrinoUri {
    @Test
    public void testInvalidUrls() {
        TestTrinoUri.assertInvalid("test", "Invalid Trino URL: test");
        TestTrinoUri.assertInvalid("trino:", "Empty Trino URL: trino:");
        TestTrinoUri.assertInvalid("mysql://localhost", "Invalid Trino URL: mysql://localhost");
        TestTrinoUri.assertInvalid("trino://localhost/", "No port number specified:");
        TestTrinoUri.assertInvalid("trino://localhost:8080/hive/default/abc", "Invalid path segments in URL:");
        TestTrinoUri.assertInvalid("trino://localhost:8080//", "Catalog name is empty:");
        TestTrinoUri.assertInvalid("trino://localhost:8080//default", "Catalog name is empty:");
        TestTrinoUri.assertInvalid("trino://localhost:8080/a//", "Schema name is empty:");
        TestTrinoUri.assertInvalid("trino://localhost:8080/hive/default?ShoeSize=13", "Unrecognized connection property 'ShoeSize'");
        TestTrinoUri.assertInvalid("trino://localhost:8080/hive/default?SSL=", "Connection property SSL value is empty");
        TestTrinoUri.assertInvalid("trino://localhost:8080/hive/default?SSL=true&SSLVerification=", "Connection property SSLVerification value is empty");
        TestTrinoUri.assertInvalid("trino://localhost:8080/blackhole?password=a&password=b", "Connection property password is in the URL multiple times");
        TestTrinoUri.assertInvalid("trino://localhost:8080/blackhole?password&user=abc", "Connection argument is not a valid connection property: 'password'");
        TestTrinoUri.assertInvalid("trino://localhost:8080/blackhole?user=test123", "Connection property user is both in the URL and an argument");
        TestTrinoUri.assertInvalid("trino://localhost:8080?socksProxy=localhost:1080&httpProxy=localhost:8888", "Connection property socksProxy cannot be used when httpProxy is set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?httpProxy=localhost:8888&socksProxy=localhost:1080", "Connection property socksProxy cannot be used when httpProxy is set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=0", "Connection property SSL value is invalid: 0");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=1", "Connection property SSL value is invalid: 1");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=2", "Connection property SSL value is invalid: 2");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=abc", "Connection property SSL value is invalid: abc");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=0", "Connection property SSLVerification value is invalid: 0");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=abc", "Connection property SSLVerification value is invalid: abc");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLVerification=FULL", "Connection property SSLVerification requires TLS/SSL to be enabled");
        TestTrinoUri.assertInvalid("trino://localhost:443?SSLVerification=FULL", "Connection property SSLVerification requires TLS/SSL to be enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLKeyStorePassword=password", "Connection property SSLKeyStorePassword requires SSLKeyStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLKeyStoreType=type", "Connection property SSLKeyStoreType requires SSLKeyStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLTrustStorePassword=password", "Connection property SSLTrustStorePassword requires SSLTrustStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLTrustStoreType=type", "Connection property SSLTrustStoreType requires SSLTrustStorePath to be set or SSLUseSystemTrustStore to be enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLKeyStorePath=keystore.jks", "Connection property SSLKeyStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:443?SSLKeyStorePath=keystore.jks", "Connection property SSLKeyStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLTrustStorePath=truststore.jks", "Connection property SSLTrustStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:443?SSLTrustStorePath=truststore.jks", "Connection property SSLTrustStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLKeyStorePassword=password", "Connection property SSLKeyStorePassword requires SSLKeyStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLTrustStorePassword=password", "Connection property SSLTrustStorePassword requires SSLTrustStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLKeyStorePath=keystore.jks", "Connection property SSLKeyStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLKeyStorePassword=password", "Connection property SSLKeyStorePassword requires SSLKeyStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLKeyStoreType=type", "Connection property SSLKeyStoreType requires SSLKeyStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLTrustStorePath=truststore.jks", "Connection property SSLTrustStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLTrustStorePassword=password", "Connection property SSLTrustStorePassword requires SSLTrustStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLKeyStorePath=keystore.jks", "Connection property SSLKeyStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLUseSystemTrustStore=true", "Connection property SSLUseSystemTrustStore cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLUseSystemTrustStore=true&SSLTrustStorePath=truststore.jks", "Connection property SSLTrustStorePath cannot be set if SSLUseSystemTrustStore is enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?KerberosCredentialCachePath=/test", "Connection property KerberosCredentialCachePath requires KerberosRemoteServiceName to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?KerberosRemoteServiceName=test&KerberosDelegation=true&KerberosCredentialCachePath=/test", "Connection property KerberosCredentialCachePath cannot be set if KerberosDelegation is enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=:invalid", "Connection property extraCredentials value is invalid:");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=invalid:", "Connection property extraCredentials value is invalid:");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=:invalid", "Connection property extraCredentials value is invalid:");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=test.token.foo:bar;test.token.foo:xyz", "Connection property extraCredentials value is invalid");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=", "Connection property extraCredentials value is empty");
        TestTrinoUri.assertInvalid("presto://localhost:8080", "Invalid Trino URL: presto://localhost:8080");
        TestTrinoUri.assertInvalid("trino://localhost:8080?assumeLiteralNamesInMetadataCallsForNonConformingClients=true&assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=true", "Connection property assumeLiteralNamesInMetadataCallsForNonConformingClients cannot be set if assumeLiteralUnderscoreInMetadataCallsForNonConformingClients is enabled");
    }

    @Test
    public void testEmptyUser() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TrinoUri.create((String)"trino://localhost:8080?user=", (Properties)new Properties())).isInstanceOf(SQLException.class)).hasMessage("Connection property user value is empty");
    }

    @Test
    public void testEmptyPassword() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080?password=");
        Assert.assertEquals((String)parameters.getProperties().getProperty("password"), (String)"");
    }

    @Test
    public void testNonEmptyPassword() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080?password=secret");
        Assert.assertEquals((String)parameters.getProperties().getProperty("password"), (String)"secret");
    }

    @Test
    public void testUriWithSocksProxy() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080?socksProxy=localhost:1234");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "http");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.SOCKS_PROXY.toString()), (String)"localhost:1234");
    }

    @Test
    public void testUriWithHttpProxy() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080?httpProxy=localhost:5678");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "http");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.HTTP_PROXY.toString()), (String)"localhost:5678");
    }

    @Test
    public void testUriWithoutCompression() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080?disableCompression=true");
        Assert.assertTrue((boolean)parameters.isCompressionDisabled());
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.DISABLE_COMPRESSION.toString()), (String)"true");
    }

    @Test
    public void testUriWithoutSsl() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080/blackhole");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "http");
    }

    @Test
    public void testUriWithSslDisabled() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080/blackhole?SSL=false");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "http");
    }

    @Test
    public void testUriWithSslEnabled() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080/blackhole?SSL=true");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertNull((Object)properties.getProperty(PropertyName.SSL_TRUST_STORE_PATH.toString()));
        Assert.assertNull((Object)properties.getProperty(PropertyName.SSL_TRUST_STORE_PASSWORD.toString()));
    }

    @Test
    public void testUriWithSslDisabledUsing443() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:443/blackhole?SSL=false");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "http");
    }

    @Test
    public void testUriWithSslEnabledUsing443() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:443/blackhole");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "https");
    }

    @Test
    public void testUriWithSslEnabledPathOnly() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080/blackhole?SSL=true&SSLTrustStorePath=truststore.jks");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_PATH.toString()), (String)"truststore.jks");
        Assert.assertNull((Object)properties.getProperty(PropertyName.SSL_TRUST_STORE_PASSWORD.toString()));
    }

    @Test
    public void testUriWithSslEnabledPassword() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080/blackhole?SSL=true&SSLTrustStorePath=truststore.jks&SSLTrustStorePassword=password");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_PATH.toString()), (String)"truststore.jks");
        Assert.assertEquals((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_PASSWORD.toString()), (String)"password");
    }

    @Test
    public void testUriWithSslEnabledUsing443SslVerificationFull() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:443/blackhole?SSL=true&SSLVerification=FULL");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.SSL_VERIFICATION.toString()), (String)ConnectionProperties.SslVerificationMode.FULL.name());
    }

    @Test
    public void testUriWithSslEnabledUsing443SslVerificationCA() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:443/blackhole?SSL=true&SSLVerification=CA");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.SSL_VERIFICATION.toString()), (String)ConnectionProperties.SslVerificationMode.CA.name());
    }

    @Test
    public void testUriWithSslEnabledUsing443SslVerificationNONE() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:443/blackhole?SSL=true&SSLVerification=NONE");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.SSL_VERIFICATION.toString()), (String)ConnectionProperties.SslVerificationMode.NONE.name());
    }

    @Test
    public void testUriWithSslEnabledSystemTrustStoreDefault() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080/blackhole?SSL=true&SSLUseSystemTrustStore=true");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.SSL_USE_SYSTEM_TRUST_STORE.toString()), (String)"true");
    }

    @Test
    public void testUriWithSslEnabledSystemTrustStoreOverride() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080/blackhole?SSL=true&SSLTrustStoreType=Override&SSLUseSystemTrustStore=true");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_TYPE.toString()), (String)"Override");
        Assert.assertEquals((String)properties.getProperty(PropertyName.SSL_USE_SYSTEM_TRUST_STORE.toString()), (String)"true");
    }

    @Test
    public void testUriWithExtraCredentials() throws SQLException {
        String extraCredentials = "test.token.foo:bar;test.token.abc:xyz";
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080?extraCredentials=" + extraCredentials);
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.EXTRA_CREDENTIALS.toString()), (String)extraCredentials);
    }

    @Test
    public void testUriWithClientTags() throws SQLException {
        String clientTags = "c1,c2";
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080?clientTags=" + clientTags);
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(PropertyName.CLIENT_TAGS.toString()), (String)clientTags);
    }

    @Test
    public void testOptionalCatalogAndSchema() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080");
        Assertions.assertThat((Optional)parameters.getCatalog()).isEmpty();
        Assertions.assertThat((Optional)parameters.getSchema()).isEmpty();
    }

    @Test
    public void testOptionalSchema() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080/catalog");
        Assertions.assertThat((Optional)parameters.getCatalog()).isPresent();
        Assertions.assertThat((Optional)parameters.getSchema()).isEmpty();
    }

    @Test
    public void testAssumeLiteralNamesInMetadataCallsForNonConformingClients() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080?assumeLiteralNamesInMetadataCallsForNonConformingClients=true");
        Assertions.assertThat((boolean)parameters.isAssumeLiteralNamesInMetadataCallsForNonConformingClients()).isTrue();
        Assertions.assertThat((boolean)parameters.isAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients()).isFalse();
    }

    @Test
    public void testAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients() throws SQLException {
        TrinoUri parameters = TestTrinoUri.createDriverUri("trino://localhost:8080?assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=true");
        Assertions.assertThat((boolean)parameters.isAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients()).isTrue();
        Assertions.assertThat((boolean)parameters.isAssumeLiteralNamesInMetadataCallsForNonConformingClients()).isFalse();
    }

    private static void assertUriPortScheme(TrinoUri parameters, int port, String scheme) {
        URI uri = parameters.getHttpUri();
        Assert.assertEquals((int)uri.getPort(), (int)port);
        Assert.assertEquals((String)uri.getScheme(), (String)scheme);
    }

    private static TrinoUri createDriverUri(String url) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        return TrinoUri.create((String)url, (Properties)properties);
    }

    private static void assertInvalid(String url, String prefix) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTrinoUri.createDriverUri(url)).isInstanceOf(SQLException.class)).hasMessageStartingWith(prefix);
    }
}

