/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.kerberos;

import com.google.common.base.Throwables;
import io.trino.client.auth.kerberos.BaseGSSContextProvider;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public abstract class AbstractUnconstrainedContextProvider
extends BaseGSSContextProvider {
    private GSSCredential clientCredential;

    @Override
    public GSSContext getContext(String servicePrincipal) throws GSSException {
        if (this.clientCredential == null || (double)this.clientCredential.getRemainingLifetime() < MIN_CREDENTIAL_LIFETIME.getValue(TimeUnit.SECONDS)) {
            this.clientCredential = this.createGssCredential();
        }
        return AbstractUnconstrainedContextProvider.doAs(this.getSubject(), () -> this.createContext(servicePrincipal, this.clientCredential));
    }

    private GSSCredential createGssCredential() throws GSSException {
        this.refresh();
        Subject subject = this.getSubject();
        Principal clientPrincipal = subject.getPrincipals().iterator().next();
        return AbstractUnconstrainedContextProvider.doAs(subject, () -> GSS_MANAGER.createCredential(GSS_MANAGER.createName(clientPrincipal.getName(), GSSName.NT_USER_NAME), 0, KERBEROS_OID, 1));
    }

    public abstract void refresh() throws GSSException;

    protected abstract Subject getSubject();

    static <T> T doAs(Subject subject, GssSupplier<T> action) throws GSSException {
        try {
            return (T)Subject.doAs(subject, action::get);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            Throwables.throwIfInstanceOf((Throwable)t, GSSException.class);
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    static interface GssSupplier<T> {
        public T get() throws GSSException;
    }
}

