/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.core.JsonParseException;
import io.trino.client.ClientTypeSignature;
import io.trino.client.JsonCodec;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonCodec {
    @Test
    public void testTrailingContent() throws Exception {
        JsonCodec codec = JsonCodec.jsonCodec(ClientTypeSignature.class);
        String json = "{\"rawType\":\"bigint\",\"arguments\":[]}";
        Assertions.assertThat((String)((ClientTypeSignature)codec.fromJson(json)).getRawType()).isEqualTo("bigint");
        String jsonWithTrailingContent = json + " trailer";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson(jsonWithTrailingContent)).isInstanceOf(JsonParseException.class)).hasMessageStartingWith("Unrecognized token 'trailer': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson((InputStream)new ByteArrayInputStream(jsonWithTrailingContent.getBytes(StandardCharsets.UTF_8)))).isInstanceOf(JsonParseException.class)).hasMessageStartingWith("Unrecognized token 'trailer': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')");
        String jsonWithTrailingJsonContent = json + " \"valid json value\"";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson(jsonWithTrailingJsonContent)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Found characters after the expected end of input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson((InputStream)new ByteArrayInputStream(jsonWithTrailingJsonContent.getBytes(StandardCharsets.UTF_8)))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Found characters after the expected end of input");
    }
}

