/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.collect.ImmutableSet;
import io.trino.client.ProtocolDetectionException;
import io.trino.client.ProtocolHeaders;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtocolHeaders {
    @Test
    public void testDetection() throws Exception {
        Assertions.assertThat((String)ProtocolHeaders.detectProtocol(Optional.empty(), (Set)ImmutableSet.of()).getProtocolName()).isEqualTo("Trino");
        Assertions.assertThat((String)ProtocolHeaders.detectProtocol(Optional.of("Trino"), (Set)ImmutableSet.of((Object)"X-Trino-User")).getProtocolName()).isEqualTo("Trino");
        Assertions.assertThat((String)ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Taco-User")).getProtocolName()).isEqualTo("Taco");
        Assertions.assertThat((String)ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Taco-Source")).getProtocolName()).isEqualTo("Taco");
        Assertions.assertThat((String)ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Burrito-User", (Object)"X-Burrito-Source")).getProtocolName()).isEqualTo("Trino");
        Assertions.assertThatThrownBy(() -> ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Taco-User", (Object)"X-Trino-Source"))).isInstanceOf(ProtocolDetectionException.class);
        Assertions.assertThatThrownBy(() -> ProtocolHeaders.detectProtocol(Optional.of("Taco"), (Set)ImmutableSet.of((Object)"X-Trino-User", (Object)"X-Taco-User"))).isInstanceOf(ProtocolDetectionException.class);
    }
}

