/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.client.ClientTypeSignature;
import io.trino.client.ClientTypeSignatureParameter;
import io.trino.client.NamedClientTypeSignature;
import io.trino.client.RowFieldName;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestClientTypeSignature {
    public static final JsonCodec<ClientTypeSignature> CLIENT_TYPE_SIGNATURE_CODEC;

    @Test
    public void testJsonRoundTrip() {
        ClientTypeSignature bigint = new ClientTypeSignature("bigint");
        TestClientTypeSignature.assertJsonRoundTrip(bigint);
        TestClientTypeSignature.assertJsonRoundTrip(new ClientTypeSignature("array", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofType((ClientTypeSignature)bigint))));
        TestClientTypeSignature.assertJsonRoundTrip(new ClientTypeSignature("foo", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofLong((long)42L))));
        TestClientTypeSignature.assertJsonRoundTrip(new ClientTypeSignature("row", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofNamedType((NamedClientTypeSignature)new NamedClientTypeSignature(Optional.of(new RowFieldName("foo")), bigint)), (Object)ClientTypeSignatureParameter.ofNamedType((NamedClientTypeSignature)new NamedClientTypeSignature(Optional.of(new RowFieldName("bar")), bigint)))));
    }

    @Test
    public void testStringSerialization() {
        ClientTypeSignature bigint = new ClientTypeSignature("bigint");
        ClientTypeSignature varchar = new ClientTypeSignature("varchar", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofLong((long)50L)));
        Assertions.assertThat((String)bigint.toString()).isEqualTo("bigint");
        Assertions.assertThat((String)varchar.toString()).isEqualTo("varchar(50)");
        ClientTypeSignature array = new ClientTypeSignature("array", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofType((ClientTypeSignature)new ClientTypeSignature("bigint"))));
        Assertions.assertThat((String)array.toString()).isEqualTo("array(bigint)");
        ClientTypeSignature row = new ClientTypeSignature("row", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofNamedType((NamedClientTypeSignature)new NamedClientTypeSignature(Optional.of(new RowFieldName("foo")), bigint)), (Object)ClientTypeSignatureParameter.ofNamedType((NamedClientTypeSignature)new NamedClientTypeSignature(Optional.of(new RowFieldName("bar")), bigint))));
        Assertions.assertThat((String)row.toString()).isEqualTo("row(foo bigint,bar bigint)");
    }

    private static void assertJsonRoundTrip(ClientTypeSignature signature) {
        String json = CLIENT_TYPE_SIGNATURE_CODEC.toJson((Object)signature);
        ClientTypeSignature copy = (ClientTypeSignature)CLIENT_TYPE_SIGNATURE_CODEC.fromJson(json);
        Assertions.assertThat((Object)copy).isEqualTo((Object)signature);
    }

    static {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        JsonCodecFactory codecFactory = new JsonCodecFactory((Provider)provider);
        CLIENT_TYPE_SIGNATURE_CODEC = codecFactory.jsonCodec(ClientTypeSignature.class);
    }
}

