/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.external;

import com.google.common.collect.ImmutableList;
import io.trino.client.auth.external.TokenPollResult;
import io.trino.client.auth.external.TokenPoller;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;

public final class MockTokenPoller
implements TokenPoller {
    private final Map<URI, BlockingDeque<TokenPollResult>> results = new ConcurrentHashMap<URI, BlockingDeque<TokenPollResult>>();
    private URI tokenReceivedUri;

    public static TokenPoller onPoll(final Function<URI, TokenPollResult> pollingStrategy) {
        return new TokenPoller(){

            public TokenPollResult pollForToken(URI tokenUri, Duration timeout) {
                return (TokenPollResult)pollingStrategy.apply(tokenUri);
            }

            public void tokenReceived(URI tokenUri) {
            }
        };
    }

    public MockTokenPoller withResult(URI tokenUri, TokenPollResult result) {
        this.results.compute(tokenUri, (uri, queue) -> {
            if (queue == null) {
                return new LinkedBlockingDeque(ImmutableList.of((Object)result));
            }
            queue.add(result);
            return queue;
        });
        return this;
    }

    public TokenPollResult pollForToken(URI tokenUri, Duration ignored) {
        BlockingDeque<TokenPollResult> queue = this.results.get(tokenUri);
        if (queue == null) {
            throw new IllegalArgumentException("Unknown token URI: " + tokenUri);
        }
        return queue.remove();
    }

    public void tokenReceived(URI tokenUri) {
        this.tokenReceivedUri = tokenUri;
    }

    public URI tokenReceivedUri() {
        return this.tokenReceivedUri;
    }
}

