/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling.encoding;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import io.trino.client.QueryDataDecoder;
import io.trino.client.ResultRows;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.encoding.CompressedQueryDataDecoder;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestCompressedQueryDataDecoder {
    private static final List<List<Object>> SAMPLE_VALUES = ImmutableList.of((Object)ImmutableList.of((Object)"hello", (Object)"world"));

    TestCompressedQueryDataDecoder() {
    }

    @Test
    public void testClosesUnderlyingInputStreamIfCompressed() throws IOException {
        final AtomicBoolean closed = new AtomicBoolean();
        FilterInputStream stream = new FilterInputStream(this, new ByteArrayInputStream("compressed".getBytes(StandardCharsets.UTF_8))){
            final /* synthetic */ TestCompressedQueryDataDecoder this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void close() throws IOException {
                super.close();
                closed.set(true);
            }
        };
        TestQueryDataDecoder decoder = new TestQueryDataDecoder(new QueryDataDecoder(){

            public ResultRows decode(InputStream input, DataAttributes segmentAttributes) throws IOException {
                Assertions.assertThat((String)new String(ByteStreams.toByteArray((InputStream)input), StandardCharsets.UTF_8)).isEqualTo("decompressed");
                return SAMPLE_VALUES::iterator;
            }

            public String encoding() {
                return "test";
            }
        });
        Assertions.assertThat((boolean)closed.get()).isFalse();
        Assertions.assertThat((Iterable)decoder.decode(stream, DataAttributes.builder().set(DataAttribute.UNCOMPRESSED_SIZE, (Object)"decompressed".length()).set(DataAttribute.SEGMENT_SIZE, (Object)"compressed".length()).build())).containsAll(SAMPLE_VALUES);
        Assertions.assertThat((boolean)closed.get()).isTrue();
    }

    @Test
    public void testDelegatesClosingIfUncompressed() throws IOException {
        final AtomicBoolean closed = new AtomicBoolean();
        FilterInputStream stream = new FilterInputStream(this, new ByteArrayInputStream("not compressed".getBytes(StandardCharsets.UTF_8))){
            final /* synthetic */ TestCompressedQueryDataDecoder this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void close() throws IOException {
                super.close();
                closed.set(true);
            }
        };
        TestQueryDataDecoder decoder = new TestQueryDataDecoder(new QueryDataDecoder(){

            public ResultRows decode(InputStream input, DataAttributes segmentAttributes) throws IOException {
                Assertions.assertThat((String)new String(ByteStreams.toByteArray((InputStream)input), StandardCharsets.UTF_8)).isEqualTo("not compressed");
                input.close();
                return new ResultRows(){

                    public Iterator<List<Object>> iterator() {
                        return SAMPLE_VALUES.iterator();
                    }
                };
            }

            public String encoding() {
                return "test";
            }
        });
        Assertions.assertThat((boolean)closed.get()).isFalse();
        Assertions.assertThat((Iterable)decoder.decode(stream, DataAttributes.builder().set(DataAttribute.SEGMENT_SIZE, (Object)"not compressed".length()).build())).containsAll(SAMPLE_VALUES);
        Assertions.assertThat((boolean)closed.get()).isTrue();
    }

    private static class TestQueryDataDecoder
    extends CompressedQueryDataDecoder {
        public TestQueryDataDecoder(QueryDataDecoder delegate) {
            super(delegate);
        }

        void decompress(byte[] bytes, byte[] output) {
            Assertions.assertThat((String)new String(bytes, StandardCharsets.UTF_8)).isEqualTo("compressed");
            byte[] uncompressed = "decompressed".getBytes(StandardCharsets.UTF_8);
            System.arraycopy(uncompressed, 0, output, 0, uncompressed.length);
        }

        public String encoding() {
            return "test";
        }
    }
}

