/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.uri;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.client.uri.ConnectionProperties;
import io.trino.client.uri.ConnectionProperty;
import io.trino.client.uri.PropertyName;
import io.trino.client.uri.TrinoUri;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTrinoUri {
    @Test
    public void testInvalidUrls() {
        TestTrinoUri.assertInvalid("test", "Invalid Trino URL: test");
        TestTrinoUri.assertInvalid("trino:", "Empty Trino URL: trino:");
        TestTrinoUri.assertInvalid("mysql://localhost", "Invalid Trino URL: mysql://localhost");
        TestTrinoUri.assertInvalid("trino://localhost:0/", "Invalid port number:");
        TestTrinoUri.assertInvalid("trino://localhost:70000/", "Invalid port number:");
        TestTrinoUri.assertInvalid("trino://localhost:8080/hive/default/abc", "Invalid path segments in URL:");
        TestTrinoUri.assertInvalid("trino://localhost:8080//", "Catalog name is empty:");
        TestTrinoUri.assertInvalid("trino://localhost:8080//default", "Catalog name is empty:");
        TestTrinoUri.assertInvalid("trino://localhost:8080/a//", "Schema name is empty:");
        TestTrinoUri.assertInvalid("trino://localhost:8080/hive/default?ShoeSize=13", "Unrecognized connection property 'ShoeSize'");
        TestTrinoUri.assertInvalid("trino://localhost:8080/hive/default?SSL=", "Connection property SSL value is empty");
        TestTrinoUri.assertInvalid("trino://localhost:8080/hive/default?SSL=true&SSLVerification=", "Connection property SSLVerification value is empty");
        TestTrinoUri.assertInvalid("trino://localhost:8080/blackhole?password=a&password=b", "Connection property password is in the URL multiple times");
        TestTrinoUri.assertInvalid("trino://localhost:8080/blackhole?password&user=abc", "Connection argument is not a valid connection property: 'password'");
        TestTrinoUri.assertInvalid("trino://localhost:8080/blackhole?user=test123", "Connection property user is passed both by URL and properties");
        TestTrinoUri.assertInvalid("trino://localhost:8080?socksProxy=localhost:1080&httpProxy=localhost:8888", "Provided connection properties are invalid:\nConnection property httpProxy cannot be used when socksProxy is set\nConnection property socksProxy cannot be used when httpProxy is set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?httpProxy=localhost:8888&socksProxy=localhost:1080", "Provided connection properties are invalid:\nConnection property httpProxy cannot be used when socksProxy is set\nConnection property socksProxy cannot be used when httpProxy is set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=0", "Connection property SSL value is invalid: 0");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=1", "Connection property SSL value is invalid: 1");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=2", "Connection property SSL value is invalid: 2");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=abc", "Connection property SSL value is invalid: abc");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=0", "Connection property SSLVerification value is invalid: 0");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=abc", "Connection property SSLVerification value is invalid: abc");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLVerification=FULL", "Connection property SSLVerification requires TLS/SSL to be enabled");
        TestTrinoUri.assertInvalid("trino://localhost:443?SSL=false&SSLVerification=FULL", "Connection property SSLVerification requires TLS/SSL to be enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLKeyStorePassword=password", "Connection property SSLKeyStorePassword requires SSLKeyStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLKeyStoreType=type", "Connection property SSLKeyStoreType requires SSLKeyStorePath to be set or SSLUseSystemKeyStore to be enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLTrustStorePassword=password", "Connection property SSLTrustStorePassword requires SSLTrustStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLTrustStoreType=type", "Connection property SSLTrustStoreType requires SSLTrustStorePath to be set or SSLUseSystemTrustStore to be enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLKeyStorePath=keystore.jks", "Connection property SSLKeyStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:443?SSL=false&SSLKeyStorePath=keystore.jks", "Connection property SSLKeyStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLTrustStorePath=truststore.jks", "Connection property SSLTrustStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:443?SSL=false&SSLTrustStorePath=truststore.jks", "Connection property SSLTrustStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLKeyStorePassword=password", "Connection property SSLKeyStorePassword requires SSLKeyStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLTrustStorePassword=password", "Connection property SSLTrustStorePassword requires SSLTrustStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLKeyStorePath=keystore.jks", "Connection property SSLKeyStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLKeyStorePassword=password", "Connection property SSLKeyStorePassword requires SSLKeyStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLKeyStoreType=type", "Connection property SSLKeyStoreType requires SSLKeyStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLTrustStorePath=truststore.jks", "Connection property SSLTrustStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLTrustStorePassword=password", "Connection property SSLTrustStorePassword requires SSLTrustStorePath to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLKeyStorePath=keystore.jks", "Connection property SSLKeyStorePath cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLUseSystemKeyStore=true", "Connection property SSLUseSystemKeyStore cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLUseSystemKeyStore=true&SSLKeyStorePath=keystore.jks", "Connection property SSLKeyStorePath cannot be set if SSLUseSystemKeyStore is enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSLUseSystemTrustStore=true", "Connection property SSLUseSystemTrustStore cannot be set if SSLVerification is set to NONE");
        TestTrinoUri.assertInvalid("trino://localhost:8080?SSL=true&SSLUseSystemTrustStore=true&SSLTrustStorePath=truststore.jks", "Connection property SSLTrustStorePath cannot be set if SSLUseSystemTrustStore is enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?KerberosCredentialCachePath=/test", "Connection property KerberosCredentialCachePath requires KerberosRemoteServiceName to be set");
        TestTrinoUri.assertInvalid("trino://localhost:8080?KerberosRemoteServiceName=test&KerberosDelegation=true&KerberosCredentialCachePath=/test", "Connection property KerberosCredentialCachePath cannot be set if KerberosDelegation is enabled");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=:invalid", "Connection property extraCredentials value is invalid:");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=invalid:", "Connection property extraCredentials value is invalid:");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=:invalid", "Connection property extraCredentials value is invalid:");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=test.token.foo:bar;test.token.foo:xyz", "Connection property extraCredentials value is invalid");
        TestTrinoUri.assertInvalid("trino://localhost:8080?extraCredentials=", "Connection property extraCredentials value is empty");
        TestTrinoUri.assertInvalid("presto://localhost:8080", "Invalid Trino URL: presto://localhost:8080");
        TestTrinoUri.assertInvalid("trino://localhost:8080?assumeLiteralNamesInMetadataCallsForNonConformingClients=true&assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=true", "Provided connection properties are invalid:\nConnection property assumeLiteralNamesInMetadataCallsForNonConformingClients cannot be set if assumeLiteralUnderscoreInMetadataCallsForNonConformingClients is enabled\nConnection property assumeLiteralUnderscoreInMetadataCallsForNonConformingClients cannot be set if assumeLiteralNamesInMetadataCallsForNonConformingClients is enabled");
    }

    @Test
    public void testUser() {
        Assertions.assertThat((Optional)TrinoUri.create((String)"trino://localhost:8080", (Properties)new Properties()).getUser()).isEmpty();
        Assertions.assertThat((Object)TrinoUri.create((String)"trino://localhost:8080", (Properties)new Properties()).getProperties().get("user")).isNull();
        Assertions.assertThat((Optional)TrinoUri.create((String)"trino://localhost:8080?user=trino", (Properties)new Properties()).getUser()).hasValue((Object)"trino");
        Assertions.assertThat((Object)TrinoUri.create((String)"trino://localhost:8080?user=trino", (Properties)new Properties()).getProperties().get("user")).isEqualTo((Object)"trino");
    }

    @Test
    public void testEmptyUser() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TrinoUri.create((String)"trino://localhost:8080?user=", (Properties)new Properties())).isInstanceOf(RuntimeException.class)).hasMessage("Connection property user value is empty");
    }

    @Test
    public void testMultipleInvalidProperties() {
        Assertions.assertThatThrownBy(() -> TrinoUri.create((String)"trino://localhost:8080?user=&SSLVerification=true", (Properties)new Properties())).hasMessageContaining("Provided connection properties are invalid:\nConnection property SSLVerification requires TLS/SSL to be enabled\nConnection property user value is empty");
    }

    @Test
    public void testEmptyPassword() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:443?password=");
        Assertions.assertThat((String)parameters.getProperties().getProperty("password")).isEmpty();
    }

    @Test
    public void testNonEmptyPassword() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:443?password=secret");
        Assertions.assertThat((String)parameters.getProperties().getProperty("password")).isEqualTo("secret");
    }

    @Test
    public void testUriWithSocksProxy() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080?socksProxy=localhost:1234");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "http");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SOCKS_PROXY.toString())).isEqualTo("localhost:1234");
    }

    @Test
    public void testUriWithHttpProxy() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080?httpProxy=localhost:5678");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "http");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.HTTP_PROXY.toString())).isEqualTo("localhost:5678");
    }

    @Test
    public void testSqlPath() {
        TestTrinoUri.assertInvalid("trino://localhost:8080?path=catalog.schema.whatever", "Connection property 'path' has invalid syntax, should be [catalog].[schema] or [schema]");
        Assertions.assertThat((Optional)TestTrinoUri.createTrinoUri("trino://localhost:8080?path=catalog.schema,catalog2").getPath()).hasValue((Object)ImmutableList.of((Object)"catalog.schema", (Object)"catalog2"));
        Assertions.assertThat((Optional)TestTrinoUri.createTrinoUri("trino://localhost:8080?path=schema").getPath()).hasValue((Object)ImmutableList.of((Object)"schema"));
    }

    @Test
    public void testUriWithoutCompression() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080?disableCompression=true");
        Assertions.assertThat((boolean)parameters.isCompressionDisabled()).isTrue();
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.DISABLE_COMPRESSION.toString())).isEqualTo("true");
    }

    @Test
    public void testUriWithoutSsl() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/blackhole");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "http");
    }

    @Test
    public void testUriWithSslDisabled() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/blackhole?SSL=false");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "http");
    }

    @Test
    public void testUriWithSslEnabled() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/blackhole?SSL=true");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_PATH.toString())).isNull();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_PASSWORD.toString())).isNull();
    }

    @Test
    public void testUriWithSslDisabledUsing443() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:443/blackhole?SSL=false");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "http");
    }

    @Test
    public void testUriWithSslEnabledUsing443() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:443/blackhole");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "https");
    }

    @Test
    public void testUriWithSslEnabledPathOnly() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/blackhole?SSL=true&SSLTrustStorePath=truststore.jks");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_PATH.toString())).isEqualTo("truststore.jks");
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_PASSWORD.toString())).isNull();
    }

    @Test
    public void testUriWithSslEnabledPassword() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/blackhole?SSL=true&SSLTrustStorePath=truststore.jks&SSLTrustStorePassword=password");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_PATH.toString())).isEqualTo("truststore.jks");
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_PASSWORD.toString())).isEqualTo("password");
    }

    @Test
    public void testUriWithSslEnabledUsing443SslVerificationFull() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:443/blackhole?SSL=true&SSLVerification=FULL");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_VERIFICATION.toString())).isEqualTo(ConnectionProperties.SslVerificationMode.FULL.name());
    }

    @Test
    public void testUriWithSslEnabledUsing443SslVerificationCA() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:443/blackhole?SSL=true&SSLVerification=CA");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_VERIFICATION.toString())).isEqualTo(ConnectionProperties.SslVerificationMode.CA.name());
    }

    @Test
    public void testUriWithSslEnabledUsing443SslVerificationNONE() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:443/blackhole?SSL=true&SSLVerification=NONE");
        TestTrinoUri.assertUriPortScheme(parameters, 443, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_VERIFICATION.toString())).isEqualTo(ConnectionProperties.SslVerificationMode.NONE.name());
    }

    @Test
    public void testUriWithSslEnabledSystemKeyStoreDefault() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/blackhole?SSL=true&SSLUseSystemKeyStore=true");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_USE_SYSTEM_KEY_STORE.toString())).isEqualTo("true");
    }

    @Test
    public void testUriWithSslEnabledSystemKeyStoreOverride() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/blackhole?SSL=true&SSLKeyStoreType=Override&SSLUseSystemKeyStore=true");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_KEY_STORE_TYPE.toString())).isEqualTo("Override");
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_USE_SYSTEM_KEY_STORE.toString())).isEqualTo("true");
    }

    @Test
    public void testUriWithSslEnabledSystemTrustStoreDefault() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/blackhole?SSL=true&SSLUseSystemTrustStore=true");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_USE_SYSTEM_TRUST_STORE.toString())).isEqualTo("true");
    }

    @Test
    public void testUriWithSslEnabledSystemTrustStoreOverride() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/blackhole?SSL=true&SSLTrustStoreType=Override&SSLUseSystemTrustStore=true");
        TestTrinoUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_TRUST_STORE_TYPE.toString())).isEqualTo("Override");
        Assertions.assertThat((String)properties.getProperty(PropertyName.SSL_USE_SYSTEM_TRUST_STORE.toString())).isEqualTo("true");
    }

    @Test
    public void testUriWithExtraCredentials() {
        String extraCredentials = "test.token.foo:bar;test.token.abc:xyz";
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080?extraCredentials=" + extraCredentials);
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.EXTRA_CREDENTIALS.toString())).isEqualTo(extraCredentials);
    }

    @Test
    public void testUriWithClientTags() {
        String clientTags = "c1,c2";
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080?clientTags=" + clientTags);
        Properties properties = parameters.getProperties();
        Assertions.assertThat((String)properties.getProperty(PropertyName.CLIENT_TAGS.toString())).isEqualTo(clientTags);
    }

    @Test
    public void testOptionalCatalogAndSchema() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080");
        Assertions.assertThat((Optional)parameters.getCatalog()).isEmpty();
        Assertions.assertThat((Optional)parameters.getSchema()).isEmpty();
    }

    @Test
    public void testOptionalSchema() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080/catalog");
        Assertions.assertThat((Optional)parameters.getCatalog()).isPresent();
        Assertions.assertThat((Optional)parameters.getSchema()).isEmpty();
    }

    @Test
    public void testAssumeLiteralNamesInMetadataCallsForNonConformingClients() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080?assumeLiteralNamesInMetadataCallsForNonConformingClients=true");
        Assertions.assertThat((boolean)parameters.isAssumeLiteralNamesInMetadataCallsForNonConformingClients()).isTrue();
        Assertions.assertThat((boolean)parameters.isAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients()).isFalse();
    }

    @Test
    public void testAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients() {
        TrinoUri parameters = TestTrinoUri.createTrinoUri("trino://localhost:8080?assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=true");
        Assertions.assertThat((boolean)parameters.isAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients()).isTrue();
        Assertions.assertThat((boolean)parameters.isAssumeLiteralNamesInMetadataCallsForNonConformingClients()).isFalse();
    }

    @Test
    public void testBuilderSetsAllProperties() {
        Set setters = (Set)Arrays.stream(TrinoUri.Builder.class.getDeclaredMethods()).filter(method -> Modifier.isPublic(method.getModifiers())).map(Method::getName).filter(method -> method.startsWith("set")).filter(method -> !TestTrinoUri.isBuilderHelperMethod(method)).map(method -> method.substring(3)).map(String::toLowerCase).collect(ImmutableSet.toImmutableSet());
        Set allProperties = (Set)ConnectionProperties.allProperties().stream().map(ConnectionProperty::getKey).map(String::toLowerCase).collect(ImmutableSet.toImmutableSet());
        Assertions.assertThat((Collection)allProperties).hasSameElementsAs((Iterable)setters);
    }

    @Test
    public void testDefaultPorts() {
        TrinoUri uri = TestTrinoUri.createTrinoUri("trino://localhost");
        Assertions.assertThat((URI)uri.getHttpUri()).isEqualTo((Object)URI.create("http://localhost:80"));
        TrinoUri secureUri = TestTrinoUri.createTrinoUri("trino://localhost?SSL=true");
        Assertions.assertThat((URI)secureUri.getHttpUri()).isEqualTo((Object)URI.create("https://localhost:443"));
    }

    private static boolean isBuilderHelperMethod(String name) {
        if (name.equals("setSslVerificationNone")) {
            return true;
        }
        return name.equals("setRestrictedProperties") || name.equals("setUri");
    }

    private static void assertUriPortScheme(TrinoUri parameters, int port, String scheme) {
        URI uri = parameters.getHttpUri();
        Assertions.assertThat((int)uri.getPort()).isEqualTo(port);
        Assertions.assertThat((String)uri.getScheme()).isEqualTo(scheme);
    }

    private static TrinoUri createTrinoUri(String url) {
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        return TrinoUri.create((String)url, (Properties)properties);
    }

    private static void assertInvalid(String url, String prefix) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTrinoUri.createTrinoUri(url)).isInstanceOf(RuntimeException.class)).hasMessageStartingWith(prefix);
    }
}

