/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.uri;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.trino.client.ClientSelectedRole;
import io.trino.client.uri.ConnectionProperties;
import io.trino.client.uri.ConnectionProperty;
import io.trino.client.uri.LoggingLevel;
import io.trino.client.uri.TrinoUri;
import java.net.URI;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTrinoUriBuilder {
    @Test
    public void testSetSimpleValues() {
        this.assertRoundTrip(ConnectionProperties.USER, "marian", "marian");
        this.assertRoundTrip(ConnectionProperties.PASSWORD, "password", "password");
        this.assertRoundTrip(ConnectionProperties.CATALOG, "test", "test");
        this.assertRoundTrip(ConnectionProperties.SESSION_USER, "test", "test");
        this.assertRoundTrip(ConnectionProperties.SOCKS_PROXY, HostAndPort.fromParts((String)"proxy", (int)443), "proxy:443");
        this.assertRoundTrip(ConnectionProperties.HTTP_PROXY, HostAndPort.fromParts((String)"proxy", (int)443), "proxy:443");
        this.assertRoundTrip(ConnectionProperties.APPLICATION_NAME_PREFIX, "prefix", "prefix");
        this.assertRoundTrip(ConnectionProperties.DISABLE_COMPRESSION, true, "true");
        this.assertRoundTrip(ConnectionProperties.ASSUME_LITERAL_NAMES_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS, true, "true");
        this.assertRoundTrip(ConnectionProperties.ASSUME_LITERAL_UNDERSCORE_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS, true, "true");
        this.assertRoundTrip(ConnectionProperties.SSL, true, "true");
        this.assertRoundTrip(ConnectionProperties.TIMEOUT, Duration.valueOf((String)"30s"), "30.00s");
        this.assertRoundTrip(ConnectionProperties.HTTP_LOGGING_LEVEL, LoggingLevel.HEADERS, "HEADERS");
        this.assertRoundTrip(ConnectionProperties.LOCALE, Locale.ENGLISH, "en");
        this.assertRoundTrip(ConnectionProperties.TIMEZONE, ZoneId.of("Europe/Warsaw"), "Europe/Warsaw");
    }

    @Test
    public void testSetSimpleDependentValues() {
        this.assertRoundTrip(ConnectionProperties.SSL_VERIFICATION, ConnectionProperties.SslVerificationMode.CA, "CA", "https://localhost:443?SSL=true");
        this.assertRoundTrip(ConnectionProperties.SSL_KEY_STORE_TYPE, "jks", "jks", "https://localhost:443?SSLKeyStorePath=/tmp/file&SSLVerification=CA&SSL=true");
        this.assertRoundTrip(ConnectionProperties.SSL_KEY_STORE_PASSWORD, "password", "password", "https://localhost:443?SSLKeyStorePath=/tmp/file&SSLVerification=CA&SSL=true");
        this.assertRoundTrip(ConnectionProperties.SSL_KEY_STORE_PATH, "/tmp/path", "/tmp/path", "https://localhost:443?SSLVerification=CA&SSL=true");
        this.assertRoundTrip(ConnectionProperties.SSL_TRUST_STORE_TYPE, "jks", "jks", "https://localhost:443?SSLTrustStorePath=/tmp/file&SSLVerification=CA&SSL=true");
        this.assertRoundTrip(ConnectionProperties.SSL_TRUST_STORE_PASSWORD, "password", "password", "https://localhost:443?SSLTrustStorePath=/tmp/file&SSLVerification=CA&SSL=true");
        this.assertRoundTrip(ConnectionProperties.SSL_TRUST_STORE_PATH, "/tmp/path", "/tmp/path", "https://localhost:443?SSLVerification=CA&SSL=true");
    }

    @Test
    public void testSetRoles() {
        this.assertRoundTrip(ConnectionProperties.ROLES, ImmutableMap.of((Object)"catalog1", (Object)ClientSelectedRole.valueOf((String)"NONE"), (Object)"catalog2", (Object)ClientSelectedRole.valueOf((String)"ALL"), (Object)"catalog3", (Object)new ClientSelectedRole(ClientSelectedRole.Type.ROLE, Optional.of("public"))), "catalog1:none;catalog2:all;catalog3:public");
    }

    @Test
    public void testSetSessionProperties() {
        this.assertRoundTrip(ConnectionProperties.SESSION_PROPERTIES, ImmutableMap.of((Object)"session_key1", (Object)"session_value1", (Object)"session_key2", (Object)"session_value2", (Object)"catalog.session_key3", (Object)"session_value3"), "session_key1:session_value1;session_key2:session_value2;catalog.session_key3:session_value3");
    }

    @Test
    public void testSetResourceEstimates() {
        this.assertRoundTrip(ConnectionProperties.RESOURCE_ESTIMATES, ImmutableMap.of((Object)"EXECUTION_TIME", (Object)"10d", (Object)"CPU_TIME", (Object)"10d", (Object)"PEAK_MEMORY", (Object)"10G"), "EXECUTION_TIME:10d;CPU_TIME:10d;PEAK_MEMORY:10G");
    }

    public <T, V> void assertRoundTrip(ConnectionProperty<V, T> property, T value, V expectedSerialized) {
        this.assertRoundTrip(property, value, expectedSerialized, "https://localhost:443");
    }

    public <T, V> void assertRoundTrip(ConnectionProperty<V, T> property, T value, V expectedSerialized, String connectionUri) {
        TrinoUri uri = TrinoUri.builder().setUri(URI.create(connectionUri)).setProperty(property, value).build();
        Object actualValue = uri.getProperties().get(property.getKey());
        Assertions.assertThat((Object)actualValue).isEqualTo(expectedSerialized);
        Assertions.assertThat((Object)property.encodeValue(value)).isEqualTo(expectedSerialized);
        Assertions.assertThat((Object)property.decodeValue(expectedSerialized)).isEqualTo(value);
    }
}

