/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

class ExponentialBackOff {
    private static final long ERROR_LOGGING_DELAY_NANOS = TimeUnit.MILLISECONDS.toNanos(500L);
    private final long initialWait;
    private final long maxWait;
    private final String serverUpMessage;
    private final String serverDownMessage;
    private final Logger log;
    private final long requestStart = System.nanoTime();
    @GuardedBy(value="this")
    private boolean serverUp = true;
    @GuardedBy(value="this")
    private long currentWaitInMillis = -1L;

    public ExponentialBackOff(Duration initialWait, Duration maxWait, String serverUpMessage, String serverDownMessage, Logger log) {
        this.initialWait = Objects.requireNonNull(initialWait, "initialWait is null").toMillis();
        this.maxWait = Objects.requireNonNull(maxWait, "maxWait is null").toMillis();
        Preconditions.checkArgument((this.initialWait <= this.maxWait ? 1 : 0) != 0, (String)"initialWait %s is less than maxWait %s", (Object)initialWait, (Object)maxWait);
        this.serverUpMessage = Objects.requireNonNull(serverUpMessage, "serverUpMessage is null");
        this.serverDownMessage = Objects.requireNonNull(serverDownMessage, "serverDownMessage is null");
        this.log = Objects.requireNonNull(log, "log is null");
    }

    public synchronized void success() {
        if (!this.serverUp) {
            this.serverUp = true;
            this.log.info(this.serverUpMessage);
        }
        this.currentWaitInMillis = -1L;
    }

    public synchronized Duration failed(Throwable t) {
        if (this.serverUp && System.nanoTime() - this.requestStart >= ERROR_LOGGING_DELAY_NANOS) {
            this.serverUp = false;
            this.log.error(t, this.serverDownMessage);
        }
        this.currentWaitInMillis = this.currentWaitInMillis <= 0L ? this.initialWait : Math.min(this.currentWaitInMillis * 2L, this.maxWait);
        return new Duration((double)this.currentWaitInMillis, TimeUnit.MILLISECONDS);
    }
}

