/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class JdbcDynamicFilteringConfig {
    private boolean dynamicFilteringEnabled = true;
    private Duration dynamicFilteringWaitTimeout = new Duration(20.0, TimeUnit.SECONDS);

    public boolean isDynamicFilteringEnabled() {
        return this.dynamicFilteringEnabled;
    }

    @Config(value="dynamic-filtering.enabled")
    @ConfigDescription(value="Wait for dynamic filters before starting JDBC query")
    public JdbcDynamicFilteringConfig setDynamicFilteringEnabled(boolean dynamicFilteringEnabled) {
        this.dynamicFilteringEnabled = dynamicFilteringEnabled;
        return this;
    }

    @NotNull
    public Duration getDynamicFilteringWaitTimeout() {
        return this.dynamicFilteringWaitTimeout;
    }

    @Config(value="dynamic-filtering.wait-timeout")
    @ConfigDescription(value="Duration to wait for completion of dynamic filters")
    public JdbcDynamicFilteringConfig setDynamicFilteringWaitTimeout(Duration dynamicFilteringWaitTimeout) {
        this.dynamicFilteringWaitTimeout = dynamicFilteringWaitTimeout;
        return this;
    }
}

