/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.JdbcJoinPushdownConfig;
import io.trino.plugin.jdbc.JoinPushdownStrategy;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public final class JdbcJoinPushdownSessionProperties
implements SessionPropertiesProvider {
    public static final String JOIN_PUSHDOWN_STRATEGY = "join_pushdown_strategy";
    public static final String JOIN_PUSHDOWN_AUTOMATIC_MAX_TABLE_SIZE = "join_pushdown_automatic_max_table_size";
    public static final String JOIN_PUSHDOWN_AUTOMATIC_MAX_JOIN_TO_TABLES_RATIO = "join_pushdown_automatic_max_join_to_tables_ratio";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public JdbcJoinPushdownSessionProperties(JdbcJoinPushdownConfig joinPushdownConfig) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.enumProperty((String)JOIN_PUSHDOWN_STRATEGY, (String)"Join pushdown strategy", JoinPushdownStrategy.class, (Enum)joinPushdownConfig.getJoinPushdownStrategy(), (boolean)false)).add((Object)PropertyMetadata.doubleProperty((String)JOIN_PUSHDOWN_AUTOMATIC_MAX_JOIN_TO_TABLES_RATIO, (String)"If estimated join output size is greater than or equal to ratio * sum of table sizes, then join pushdown will not be performed", (Double)joinPushdownConfig.getJoinPushdownAutomaticMaxJoinToTablesRatio(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)JOIN_PUSHDOWN_AUTOMATIC_MAX_TABLE_SIZE, (String)"Maximum table size to be considered for join pushdown", (DataSize)joinPushdownConfig.getJoinPushdownAutomaticMaxTableSize().orElse(null), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static JoinPushdownStrategy getJoinPushdownStrategy(ConnectorSession session) {
        return (JoinPushdownStrategy)((Object)session.getProperty(JOIN_PUSHDOWN_STRATEGY, JoinPushdownStrategy.class));
    }

    public static Optional<DataSize> getJoinPushdownAutomaticMaxTableSize(ConnectorSession session) {
        return Optional.ofNullable((DataSize)session.getProperty(JOIN_PUSHDOWN_AUTOMATIC_MAX_TABLE_SIZE, DataSize.class));
    }

    public static double getJoinPushdownAutomaticJoinToTablesRatio(ConnectorSession session) {
        return (Double)session.getProperty(JOIN_PUSHDOWN_AUTOMATIC_MAX_JOIN_TO_TABLES_RATIO, Double.class);
    }
}

