/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class JdbcWriteConfig {
    static final int MAX_ALLOWED_WRITE_BATCH_SIZE = 1000000;
    private int writeBatchSize = 1000;
    private boolean nonTransactionalInsert;

    @Min(value=1L)
    @Max(value=1000000L)
    public @Min(value=1L) @Max(value=1000000L) int getWriteBatchSize() {
        return this.writeBatchSize;
    }

    @Config(value="write.batch-size")
    @ConfigDescription(value="Maximum number of rows to write in a single batch")
    public JdbcWriteConfig setWriteBatchSize(int writeBatchSize) {
        this.writeBatchSize = writeBatchSize;
        return this;
    }

    public boolean isNonTransactionalInsert() {
        return this.nonTransactionalInsert;
    }

    @Config(value="insert.non-transactional-insert.enabled")
    @ConfigDescription(value="Do not create temporary table during insert. This means that the write operation can fail and leave the table in an inconsistent state.")
    public JdbcWriteConfig setNonTransactionalInsert(boolean nonTransactionalInsert) {
        this.nonTransactionalInsert = nonTransactionalInsert;
        return this;
    }
}

