/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;

public class RewriteExactNumericConstant
implements ConnectorExpressionRule<Constant, ParameterizedExpression> {
    private static final Pattern<Constant> PATTERN = ConnectorExpressionPatterns.constant().with(ConnectorExpressionPatterns.type().matching(type -> type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT || type instanceof DecimalType));

    public Pattern<Constant> getPattern() {
        return PATTERN;
    }

    public Optional<ParameterizedExpression> rewrite(Constant constant, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        Type type = constant.getType();
        Object value = constant.getValue();
        if (value == null) {
            return Optional.empty();
        }
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT || type instanceof DecimalType) {
            return Optional.of(new ParameterizedExpression("?", (List<QueryParameter>)ImmutableList.of((Object)new QueryParameter(type, Optional.of(value)))));
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }
}

