/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.procedure;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.CachingJdbcClient;
import io.trino.plugin.jdbc.mapping.CachingIdentifierMapping;
import io.trino.spi.procedure.Procedure;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

public class FlushJdbcMetadataCacheProcedure
implements Provider<Procedure> {
    private static final MethodHandle FLUSH_JDBC_METADATA_CACHE;
    private final CachingJdbcClient cachingJdbcClient;
    private final Optional<CachingIdentifierMapping> cachingIdentifierMapping;

    @Inject
    public FlushJdbcMetadataCacheProcedure(CachingJdbcClient cachingJdbcClient, Optional<CachingIdentifierMapping> cachingIdentifierMapping) {
        this.cachingJdbcClient = Objects.requireNonNull(cachingJdbcClient, "cachingJdbcClient is null");
        this.cachingIdentifierMapping = Objects.requireNonNull(cachingIdentifierMapping, "cachingIdentifierMapping is null");
    }

    public Procedure get() {
        return new Procedure("system", "flush_metadata_cache", (List)ImmutableList.of(), FLUSH_JDBC_METADATA_CACHE.bindTo(this));
    }

    public void flushMetadataCache() {
        this.cachingJdbcClient.flushCache();
        this.cachingIdentifierMapping.ifPresent(CachingIdentifierMapping::flushCache);
    }

    static {
        try {
            FLUSH_JDBC_METADATA_CACHE = MethodHandles.lookup().unreflect(FlushJdbcMetadataCacheProcedure.class.getMethod("flushMetadataCache", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

