/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeConfig;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeManager;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStats;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStorage;
import io.trino.plugin.exchange.filesystem.azure.AzureBlobFileSystemExchangeStorage;
import io.trino.plugin.exchange.filesystem.azure.ExchangeAzureConfig;
import io.trino.plugin.exchange.filesystem.local.LocalFileSystemExchangeStorage;
import io.trino.plugin.exchange.filesystem.s3.ExchangeS3Config;
import io.trino.plugin.exchange.filesystem.s3.S3FileSystemExchangeStorage;
import io.trino.plugin.exchange.filesystem.s3.S3FileSystemExchangeStorageStats;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.net.URI;
import java.util.List;
import org.weakref.jmx.guice.ExportBinder;

public class FileSystemExchangeModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(FileSystemExchangeStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(FileSystemExchangeStats.class).withGeneratedName();
        binder.bind(FileSystemExchangeManager.class).in(Scopes.SINGLETON);
        List<URI> baseDirectories = ((FileSystemExchangeConfig)this.buildConfigObject(FileSystemExchangeConfig.class)).getBaseDirectories();
        if (baseDirectories.stream().map(URI::getScheme).distinct().count() != 1L) {
            binder.addError((Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "Multiple schemes in exchange base directories"));
            return;
        }
        String scheme = baseDirectories.get(0).getScheme();
        if (scheme == null || scheme.equals("file")) {
            binder.bind(FileSystemExchangeStorage.class).to(LocalFileSystemExchangeStorage.class).in(Scopes.SINGLETON);
        } else if (ImmutableSet.of((Object)"s3", (Object)"gs").contains((Object)scheme)) {
            binder.bind(S3FileSystemExchangeStorageStats.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(S3FileSystemExchangeStorageStats.class).withGeneratedName();
            binder.bind(FileSystemExchangeStorage.class).to(S3FileSystemExchangeStorage.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(ExchangeS3Config.class);
            S3FileSystemExchangeStorage.CompatibilityMode compatibilityMode = scheme.equals("gs") ? S3FileSystemExchangeStorage.CompatibilityMode.GCP : S3FileSystemExchangeStorage.CompatibilityMode.AWS;
            binder.bind(S3FileSystemExchangeStorage.CompatibilityMode.class).toInstance((Object)compatibilityMode);
        } else if (ImmutableSet.of((Object)"abfs", (Object)"abfss").contains((Object)scheme)) {
            binder.bind(FileSystemExchangeStorage.class).to(AzureBlobFileSystemExchangeStorage.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(ExchangeAzureConfig.class);
        } else {
            binder.addError((Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Scheme %s is not supported as exchange spooling storage in exchange manager type %s", scheme, "filesystem")));
        }
    }
}

