/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.trino.plugin.exchange.filesystem.ExchangeSourceFile;
import io.trino.plugin.exchange.filesystem.ExchangeStorageReader;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSourceHandle;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStats;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStorage;
import io.trino.spi.exchange.ExchangeSource;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.spi.exchange.ExchangeSourceOutputSelector;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FileSystemExchangeSource
implements ExchangeSource {
    private final FileSystemExchangeStorage exchangeStorage;
    private final FileSystemExchangeStats stats;
    private final int maxPageStorageSize;
    private final int exchangeSourceConcurrentReaders;
    private final int maxFilesPerReader;
    private final Queue<ExchangeSourceFile> files = new ConcurrentLinkedQueue<ExchangeSourceFile>();
    @GuardedBy(value="this")
    private boolean noMoreFiles;
    @GuardedBy(value="this")
    private ExchangeSourceOutputSelector currentSelector;
    @GuardedBy(value="this")
    private SettableFuture<Void> blockedOnFiles = SettableFuture.create();
    private final AtomicReference<List<ExchangeStorageReader>> readers = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final AtomicReference<ListenableFuture<Void>> blocked = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean();

    public FileSystemExchangeSource(FileSystemExchangeStorage exchangeStorage, FileSystemExchangeStats stats, int maxPageStorageSize, int exchangeSourceConcurrentReaders, int maxFilesPerReader) {
        this.exchangeStorage = Objects.requireNonNull(exchangeStorage, "exchangeStorage is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.maxPageStorageSize = maxPageStorageSize;
        this.exchangeSourceConcurrentReaders = exchangeSourceConcurrentReaders;
        this.maxFilesPerReader = maxFilesPerReader;
    }

    public synchronized void addSourceHandles(List<ExchangeSourceHandle> handles) {
        if (this.closed.get()) {
            return;
        }
        this.files.addAll(FileSystemExchangeSource.getFiles(handles));
        this.closeAndCreateReadersIfNecessary();
    }

    public synchronized void noMoreSourceHandles() {
        this.noMoreFiles = true;
        this.closeAndCreateReadersIfNecessary();
    }

    public synchronized void setOutputSelector(ExchangeSourceOutputSelector newSelector) {
        if (this.currentSelector != null) {
            if (this.currentSelector.getVersion() >= newSelector.getVersion()) {
                return;
            }
            this.currentSelector.checkValidTransition(newSelector);
        }
        this.currentSelector = newSelector;
        this.closeAndCreateReadersIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> isBlocked() {
        if (this.closed.get()) {
            return NOT_BLOCKED;
        }
        Object blocked = this.blocked.get();
        if (blocked != null && !blocked.isDone()) {
            return FileSystemExchangeSource.nonCancellationPropagatingCompletableFuture(blocked);
        }
        List<ExchangeStorageReader> readers = this.readers.get();
        for (int i = 0; i < readers.size(); ++i) {
            ExchangeStorageReader reader = readers.get(i);
            if (!reader.isBlocked().isDone()) continue;
            return NOT_BLOCKED;
        }
        FileSystemExchangeSource fileSystemExchangeSource = this;
        synchronized (fileSystemExchangeSource) {
            blocked = !this.blockedOnFiles.isDone() ? this.blockedOnFiles : (readers.isEmpty() ? Futures.immediateVoidFuture() : MoreFutures.whenAnyComplete((Iterable)((Iterable)readers.stream().map(ExchangeStorageReader::isBlocked).collect(ImmutableList.toImmutableList()))));
            blocked = this.stats.getExchangeSourceBlocked().record(blocked);
            this.blocked.set((ListenableFuture<Void>)blocked);
        }
        return FileSystemExchangeSource.nonCancellationPropagatingCompletableFuture((ListenableFuture<Void>)blocked);
    }

    private static CompletableFuture<Void> nonCancellationPropagatingCompletableFuture(ListenableFuture<Void> future) {
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void value) {
                result.complete(value);
            }

            public void onFailure(Throwable t) {
                result.completeExceptionally(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    public boolean isFinished() {
        return this.closed.get();
    }

    @Nullable
    public Slice read() {
        if (this.closed.get()) {
            return null;
        }
        Slice data = null;
        List<ExchangeStorageReader> readers = this.readers.get();
        for (int i = 0; i < readers.size(); ++i) {
            ExchangeStorageReader reader = readers.get(i);
            if (!reader.isBlocked().isDone() || reader.isFinished()) continue;
            try {
                data = reader.read();
                break;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.closeAndCreateReadersIfNecessary();
        return data;
    }

    public long getMemoryUsage() {
        long memoryUsage = 0L;
        List<ExchangeStorageReader> readers = this.readers.get();
        for (int i = 0; i < readers.size(); ++i) {
            memoryUsage += readers.get(i).getRetainedSize();
        }
        return memoryUsage;
    }

    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.files.clear();
        Closer closer = Closer.create();
        for (ExchangeStorageReader reader : this.readers.getAndSet((List<ExchangeStorageReader>)ImmutableList.of())) {
            closer.register((Closeable)reader);
        }
        try {
            closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndCreateReadersIfNecessary() {
        int numberOfActiveReaders = this.getNumberOfActiveReaders();
        if (numberOfActiveReaders == this.exchangeSourceConcurrentReaders) {
            return;
        }
        if (numberOfActiveReaders > 0 && this.files.isEmpty()) {
            return;
        }
        SettableFuture<Void> blockedOnFilesToBeUnblocked = null;
        FileSystemExchangeSource fileSystemExchangeSource = this;
        synchronized (fileSystemExchangeSource) {
            if (this.closed.get()) {
                return;
            }
            if (this.currentSelector == null || !this.currentSelector.isFinal()) {
                return;
            }
            ArrayList<ExchangeStorageReader> activeReaders = new ArrayList<ExchangeStorageReader>();
            for (ExchangeStorageReader reader : this.readers.get()) {
                if (reader.isFinished()) {
                    reader.close();
                    continue;
                }
                activeReaders.add(reader);
            }
            try {
                while (activeReaders.size() < this.exchangeSourceConcurrentReaders && !this.files.isEmpty()) {
                    ImmutableList.Builder readerFiles = ImmutableList.builder();
                    int readerFileCount = 0;
                    long readerFileSize = 0L;
                    while (!this.files.isEmpty()) {
                        ExchangeSourceFile file = this.files.peek();
                        Verify.verify((this.currentSelector.getSelection(file.getExchangeId(), file.getSourceTaskPartitionId(), file.getSourceTaskAttemptId()) == ExchangeSourceOutputSelector.Selection.INCLUDED ? 1 : 0) != 0, (String)"%s.%s.%s is not marked as included by the engine", (Object)file.getExchangeId(), (Object)file.getSourceTaskPartitionId(), (Object)file.getSourceTaskAttemptId());
                        if (readerFileCount != 0 && (readerFileSize + file.getFileSize() > (long)(this.maxPageStorageSize + this.exchangeStorage.getWriteBufferSize()) || readerFileCount >= this.maxFilesPerReader)) break;
                        readerFiles.add((Object)file);
                        readerFileSize += file.getFileSize();
                        ++readerFileCount;
                        this.files.poll();
                    }
                    activeReaders.add(this.exchangeStorage.createExchangeStorageReader((List<ExchangeSourceFile>)readerFiles.build(), this.maxPageStorageSize));
                }
                if (activeReaders.isEmpty()) {
                    if (this.noMoreFiles) {
                        blockedOnFilesToBeUnblocked = this.blockedOnFiles;
                        this.close();
                    } else if (this.blockedOnFiles.isDone()) {
                        this.blockedOnFiles = SettableFuture.create();
                    }
                } else if (!this.blockedOnFiles.isDone()) {
                    blockedOnFilesToBeUnblocked = this.blockedOnFiles;
                }
                this.readers.set((List<ExchangeStorageReader>)ImmutableList.copyOf(activeReaders));
            }
            catch (Throwable t) {
                for (ExchangeStorageReader reader : activeReaders) {
                    try {
                        reader.close();
                    }
                    catch (Throwable closeFailure) {
                        if (closeFailure == t) continue;
                        t.addSuppressed(closeFailure);
                    }
                }
                throw t;
            }
        }
        if (blockedOnFilesToBeUnblocked != null) {
            blockedOnFilesToBeUnblocked.set(null);
        }
    }

    private int getNumberOfActiveReaders() {
        List<ExchangeStorageReader> readers = this.readers.get();
        int result = 0;
        for (int i = 0; i < readers.size(); ++i) {
            ExchangeStorageReader reader = readers.get(i);
            if (reader.isFinished()) continue;
            ++result;
        }
        return result;
    }

    private static List<ExchangeSourceFile> getFiles(List<ExchangeSourceHandle> handles) {
        return (List)handles.stream().map(FileSystemExchangeSourceHandle.class::cast).flatMap(handle -> handle.getFiles().stream().map(sourceFile -> new ExchangeSourceFile(URI.create(sourceFile.getFilePath()), sourceFile.getFileSize(), handle.getExchangeId(), sourceFile.getSourceTaskPartitionId(), sourceFile.getSourceTaskAttemptId()))).collect(ImmutableList.toImmutableList());
    }
}

