/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.trino.jmh.Benchmarks;
import io.trino.plugin.geospatial.BingTileFunctions;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkBingTilesAround {
    @Benchmark
    public Object benchmark(BenchmarkData data) {
        return BingTileFunctions.bingTilesAround((double)0.0, (double)0.0, (long)data.zoomLevel, (double)data.radiusKm);
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.zoomLevel = 10;
        new BenchmarkBingTilesAround().benchmark(data);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkBingTilesAround.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"10", "14", "20"})
        private int zoomLevel;
        @Param(value={"0.1", "1", "5"})
        private double radiusKm;
    }
}

