/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.geospatial.GeoFunctions;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkEnvelopeIntersection {
    @Benchmark
    public Slice envelopes(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.envelope, (Slice)data.otherEnvelope);
    }

    @Benchmark
    public Slice geometries(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.geometry, (Slice)data.otherGeometry);
    }

    @Test
    public void validate() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkEnvelopeIntersection benchmark = new BenchmarkEnvelopeIntersection();
        Assert.assertEquals((Object)GeometrySerde.deserialize((Slice)benchmark.envelopes(data)), (Object)GeometrySerde.deserialize((Slice)benchmark.geometries(data)));
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkEnvelopeIntersection.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice envelope;
        private Slice otherEnvelope;
        private Slice geometry;
        private Slice otherGeometry;

        @Setup
        public void setup() {
            this.geometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((0 0, 0 1, 1 1, 1 0, 0 0))"));
            this.otherGeometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((0.5 0.5, 0.5 1.5, 1.5 1.5, 1.5 0.5, 0.5 0.5))"));
            this.envelope = GeoFunctions.stEnvelope((Slice)this.geometry);
            this.otherEnvelope = GeoFunctions.stEnvelope((Slice)this.otherGeometry);
        }
    }
}

