/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.trino.Session;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.memory.MemoryConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingSession;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.testng.annotations.Test;

@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkGeometryAggregations {
    @Benchmark
    public MaterializedResult benchmarkArrayUnion(Context context) {
        return context.getQueryRunner().execute("SELECT geometry_union(array_agg(p.geom)) FROM us_states p");
    }

    @Benchmark
    public MaterializedResult benchmarkUnion(Context context) {
        return context.getQueryRunner().execute("SELECT geometry_union_agg(p.geom) FROM us_states p");
    }

    @Benchmark
    public MaterializedResult benchmarkConvexHull(Context context) {
        return context.getQueryRunner().execute("SELECT convex_hull_agg(p.geom) FROM us_states p");
    }

    @Test
    public void verify() throws Exception {
        Context context = new Context();
        try {
            context.setUp();
            BenchmarkGeometryAggregations benchmark = new BenchmarkGeometryAggregations();
            benchmark.benchmarkUnion(context);
            benchmark.benchmarkArrayUnion(context);
            benchmark.benchmarkConvexHull(context);
        }
        finally {
            context.queryRunner.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new BenchmarkGeometryAggregations().verify();
        Benchmarks.benchmark(BenchmarkGeometryAggregations.class).run();
    }

    @State(value=Scope.Thread)
    public static class Context {
        private LocalQueryRunner queryRunner;

        public LocalQueryRunner getQueryRunner() {
            return this.queryRunner;
        }

        @Setup
        public void setUp() throws Exception {
            String polygonValues;
            this.queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().setCatalog("memory").setSchema("default").build());
            this.queryRunner.installPlugin((Plugin)new GeoPlugin());
            this.queryRunner.createCatalog("memory", (ConnectorFactory)new MemoryConnectorFactory(), (Map)ImmutableMap.of());
            Path path = new File(Resources.getResource((String)"us-states.tsv").toURI()).toPath();
            try (Stream<String> lines = Files.lines(path);){
                polygonValues = lines.map(line -> line.split("\t")).map(parts -> String.format("('%s', '%s')", parts[0], parts[1])).collect(Collectors.joining(","));
            }
            this.queryRunner.execute(String.format("CREATE TABLE memory.default.us_states AS SELECT ST_GeometryFromText(t.wkt) AS geom FROM (VALUES %s) as t (name, wkt)", polygonValues));
        }

        @TearDown
        public void tearDown() {
            this.queryRunner.close();
            this.queryRunner = null;
        }
    }
}

