/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.io.Resources;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.geospatial.BingTileFunctions;
import io.trino.plugin.geospatial.GeoFunctions;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkGeometryToBingTiles {
    @Benchmark
    public Object geometryToBingTiles(BenchmarkData data) {
        return BingTileFunctions.geometryToBingTiles((Slice)data.geometry, (long)data.zoomLevel);
    }

    @Benchmark
    public Object envelopeToBingTiles(BenchmarkData data) {
        return BingTileFunctions.geometryToBingTiles((Slice)data.envelope, (long)data.zoomLevel);
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkGeometryToBingTiles().geometryToBingTiles(data);
        Benchmarks.benchmark(BenchmarkGeometryToBingTiles.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice geometry;
        private Slice envelope;
        private int zoomLevel;

        @Setup
        public void setup() throws Exception {
            Path filePath = new File(Resources.getResource((String)"large_polygon.txt").toURI()).toPath();
            List<String> lines = Files.readAllLines(filePath);
            String line = lines.get(0);
            String[] parts = line.split("\\|");
            String wkt = parts[0];
            this.geometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)wkt));
            this.envelope = GeoFunctions.stEnvelope((Slice)this.geometry);
            this.zoomLevel = Integer.parseInt(parts[1]);
        }
    }
}

