/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.geospatial.GeoFunctions;
import io.trino.plugin.geospatial.GeometryBenchmarkUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSTArea {
    @Benchmark
    public Object stSphericalArea(BenchmarkData data) {
        return GeoFunctions.stSphericalArea((Slice)data.geography);
    }

    @Benchmark
    public Object stSphericalArea500k(BenchmarkData data) {
        return GeoFunctions.stSphericalArea((Slice)data.geography500k);
    }

    @Benchmark
    public Object stArea(BenchmarkData data) {
        return GeoFunctions.stArea((Slice)data.geometry);
    }

    @Benchmark
    public Object stArea500k(BenchmarkData data) {
        return GeoFunctions.stArea((Slice)data.geometry500k);
    }

    public static void main(String[] args) throws IOException, RunnerException {
        BenchmarkSTArea.verify();
        Benchmarks.benchmark(BenchmarkSTArea.class).run();
    }

    @Test
    public static void verify() throws IOException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkSTArea benchmark = new BenchmarkSTArea();
        Assert.assertEquals((long)Math.round(1000.0 * (Double)benchmark.stSphericalArea(data) / 3.659E8), (long)1000L);
        Assert.assertEquals((long)Math.round(1000.0 * (Double)benchmark.stSphericalArea500k(data) / 3.8842273735E10), (long)1000L);
        Assert.assertEquals((Object)benchmark.stArea(data), (Object)0.05033099592771004);
        Assert.assertEquals((long)Math.round(1000.0 * (Double)benchmark.stArea500k(data) / Math.PI), (long)1000L);
    }

    private static String createPolygon(int vertexCount) {
        StringBuilder builder = new StringBuilder();
        builder.append("POLYGON((");
        builder.append(IntStream.range(0, vertexCount).mapToObj(i -> {
            double angle = (double)i * Math.PI * 2.0 / (double)vertexCount;
            return Math.cos(angle) + " " + Math.sin(angle);
        }).collect(Collectors.joining(",")));
        builder.append("))");
        return builder.toString();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice geometry;
        private Slice geometry500k;
        private Slice geography;
        private Slice geography500k;

        @Setup
        public void setup() throws IOException {
            this.geometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.loadPolygon("large_polygon.txt")));
            this.geometry500k = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)BenchmarkSTArea.createPolygon(500000)));
            this.geography = GeoFunctions.toSphericalGeography((Slice)this.geometry);
            this.geography500k = GeoFunctions.toSphericalGeography((Slice)this.geometry500k);
        }
    }
}

