/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.geospatial.GeoFunctions;
import io.trino.plugin.geospatial.GeometryBenchmarkUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@Fork(value=3)
@Warmup(iterations=5, time=3)
@Measurement(iterations=5, time=5)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.Throughput})
public class BenchmarkSTIntersects {
    @Benchmark
    public Object stIntersectsInnerLine(BenchmarkData data) {
        return GeoFunctions.stIntersects((Slice)data.innerLine, (Slice)data.geometry);
    }

    @Benchmark
    public Object stIntersectsInnerLineSimpleGeometry(BenchmarkData data) {
        return GeoFunctions.stIntersects((Slice)data.innerLine, (Slice)data.simpleGeometry);
    }

    @Benchmark
    public Object stIntersectsCrossingLine(BenchmarkData data) {
        return GeoFunctions.stIntersects((Slice)data.crossingLine, (Slice)data.geometry);
    }

    @Benchmark
    public Object stIntersectsCrossingLineSimpleGeometry(BenchmarkData data) {
        return GeoFunctions.stIntersects((Slice)data.crossingLine, (Slice)data.simpleGeometry);
    }

    @Benchmark
    public Object stIntersectsOuterLineInEnvelope(BenchmarkData data) {
        return GeoFunctions.stIntersects((Slice)data.outerLineInEnvelope, (Slice)data.geometry);
    }

    @Benchmark
    public Object stIntersectsOuterLineInEnvelopeSimpleGeometry(BenchmarkData data) {
        return GeoFunctions.stIntersects((Slice)data.outerLineInEnvelope, (Slice)data.simpleGeometry);
    }

    @Benchmark
    public Object stIntersectsOuterLineNotInEnvelope(BenchmarkData data) {
        return GeoFunctions.stIntersects((Slice)data.outerLineNotInEnvelope, (Slice)data.geometry);
    }

    @Benchmark
    public Object stIntersectsOuterLineNotInEnvelopeSimpleGeometry(BenchmarkData data) {
        return GeoFunctions.stIntersects((Slice)data.outerLineNotInEnvelope, (Slice)data.simpleGeometry);
    }

    @Test
    public void validateBenchmarkData() throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        data.validate();
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkSTIntersects.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice simpleGeometry;
        private Slice geometry;
        private Slice innerLine;
        private Slice crossingLine;
        private Slice outerLineInEnvelope;
        private Slice outerLineNotInEnvelope;

        @Setup
        public void setup() throws IOException {
            this.simpleGeometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((16.5 54, 16.5 54.1, 16.51 54.1, 16.8 54))"));
            this.geometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.loadPolygon("large_polygon.txt")));
            this.innerLine = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"LINESTRING (16.6 54.0167, 16.6 54.017)"));
            this.crossingLine = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"LINESTRING (16.6 53, 16.6 56)"));
            this.outerLineInEnvelope = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"LINESTRING (16.6667 54.05, 16.8667 54.05)"));
            this.outerLineNotInEnvelope = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"LINESTRING (16.6667 54.25, 16.8667 54.25)"));
        }

        public void validate() {
            this.validate(this.simpleGeometry);
            this.validate(this.geometry);
        }

        public void validate(Slice geometry) {
            Slice envelope = GeoFunctions.stEnvelope((Slice)geometry);
            Verify.verify((boolean)GeoFunctions.stIntersects((Slice)geometry, (Slice)this.innerLine));
            Verify.verify((boolean)GeoFunctions.stContains((Slice)geometry, (Slice)this.innerLine));
            Verify.verify((boolean)GeoFunctions.stIntersects((Slice)geometry, (Slice)this.crossingLine));
            Verify.verify((GeoFunctions.stContains((Slice)geometry, (Slice)this.crossingLine) == false ? 1 : 0) != 0);
            Verify.verify((GeoFunctions.stIntersects((Slice)geometry, (Slice)this.outerLineInEnvelope) == false ? 1 : 0) != 0);
            Verify.verify((boolean)GeoFunctions.stIntersects((Slice)envelope, (Slice)this.outerLineInEnvelope));
            Verify.verify((GeoFunctions.stIntersects((Slice)geometry, (Slice)this.outerLineNotInEnvelope) == false ? 1 : 0) != 0);
            Verify.verify((GeoFunctions.stIntersects((Slice)envelope, (Slice)this.outerLineNotInEnvelope) == false ? 1 : 0) != 0);
        }
    }
}

