/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.geospatial.GeoFunctions;
import io.trino.plugin.geospatial.GeometryBenchmarkUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSTXMin {
    @Benchmark
    public double simpleGeometry(BenchmarkData data) {
        return GeoFunctions.stXMin((Slice)data.simpleGeometry);
    }

    @Benchmark
    public double complexGeometry(BenchmarkData data) {
        return GeoFunctions.stXMin((Slice)data.complexGeometry);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkSTXMin.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice complexGeometry;
        private Slice simpleGeometry;

        @Setup
        public void setup() throws IOException {
            this.complexGeometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.loadPolygon("large_polygon.txt")));
            this.simpleGeometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((1 1, 4 1, 1 4))"));
        }
    }
}

