/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.SqlFunction;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.operator.scalar.ApplyFunction;
import io.trino.plugin.geospatial.BingTile;
import io.trino.plugin.geospatial.BingTileType;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestBingTileFunctions
extends AbstractTestFunctions {
    @BeforeClass
    public void registerFunctions() {
        this.functionAssertions.installPlugin((Plugin)new GeoPlugin());
        this.functionAssertions.addFunctions((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{ApplyFunction.APPLY_FUNCTION}));
    }

    @Test
    public void testSerialization() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        BingTile tile = BingTile.fromCoordinates((int)1, (int)2, (int)3);
        String json = objectMapper.writeValueAsString((Object)tile);
        Assert.assertEquals((String)"{\"x\":1,\"y\":2,\"zoom\":3}", (String)json);
        Assert.assertEquals((Object)tile, (Object)objectMapper.readerFor(BingTile.class).readValue(json));
    }

    @Test
    public void testArrayOfBingTiles() {
        this.assertFunction("array [bing_tile(1, 2, 10), bing_tile(3, 4, 11)]", (Type)new ArrayType((Type)BingTileType.BING_TILE), ImmutableList.of((Object)BingTile.fromCoordinates((int)1, (int)2, (int)10), (Object)BingTile.fromCoordinates((int)3, (int)4, (int)11)));
    }

    @Test
    public void testBingTile() {
        this.assertFunction("bing_tile_quadkey(bing_tile('213'))", (Type)VarcharType.VARCHAR, "213");
        this.assertFunction("bing_tile_quadkey(bing_tile('123030123010121'))", (Type)VarcharType.VARCHAR, "123030123010121");
        this.assertFunction("bing_tile_quadkey(bing_tile(3, 5, 3))", (Type)VarcharType.VARCHAR, "213");
        this.assertFunction("bing_tile_quadkey(bing_tile(21845, 13506, 15))", (Type)VarcharType.VARCHAR, "123030123010121");
        this.assertInvalidFunction("bing_tile('')", "QuadKey must not be empty string");
        this.assertInvalidFunction("bing_tile('test')", "Invalid QuadKey digit sequence: test");
        this.assertInvalidFunction("bing_tile('12345')", "Invalid QuadKey digit sequence: 12345");
        this.assertInvalidFunction("bing_tile('101010101010101010101010101010100101010101001010')", "QuadKey must be 23 characters or less");
        this.assertInvalidFunction("bing_tile(10, 2, 3)", "XY coordinates for a Bing tile at zoom level 3 must be within [0, 8) range");
        this.assertInvalidFunction("bing_tile(2, 10, 3)", "XY coordinates for a Bing tile at zoom level 3 must be within [0, 8) range");
        this.assertInvalidFunction("bing_tile(2, 7, 37)", "Zoom level must be <= 23");
    }

    @Test
    public void testPointToBingTile() {
        this.assertFunction("bing_tile_at(30.12, 60, 15)", (Type)BingTileType.BING_TILE, BingTile.fromCoordinates((int)21845, (int)13506, (int)15));
        this.assertFunction("bing_tile_at(0, -0.002, 1)", (Type)BingTileType.BING_TILE, BingTile.fromCoordinates((int)0, (int)1, (int)1));
        this.assertFunction("bing_tile_at(1e0/512, 0, 1)", (Type)BingTileType.BING_TILE, BingTile.fromCoordinates((int)1, (int)0, (int)1));
        this.assertFunction("bing_tile_at(1e0/512, 0, 9)", (Type)BingTileType.BING_TILE, BingTile.fromCoordinates((int)256, (int)255, (int)9));
        this.assertInvalidFunction("bing_tile_at(30.12, 600, 15)", "Longitude must be between -180.0 and 180.0");
        this.assertInvalidFunction("bing_tile_at(300.12, 60, 15)", "Latitude must be between -85.05112878 and 85.05112878");
        this.assertInvalidFunction("bing_tile_at(30.12, 60, 0)", "Zoom level must be > 0");
        this.assertInvalidFunction("bing_tile_at(30.12, 60, 40)", "Zoom level must be <= 23");
    }

    @Test
    public void testBingTileCoordinates() {
        this.assertFunction("bing_tile_coordinates(bing_tile('213'))[1]", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("bing_tile_coordinates(bing_tile('213'))[2]", (Type)IntegerType.INTEGER, 5);
        this.assertFunction("bing_tile_coordinates(bing_tile('123030123010121'))[1]", (Type)IntegerType.INTEGER, 21845);
        this.assertFunction("bing_tile_coordinates(bing_tile('123030123010121'))[2]", (Type)IntegerType.INTEGER, 13506);
        this.assertCachedInstanceHasBoundedRetainedSize("bing_tile_coordinates(bing_tile('213'))");
    }

    private void assertBingTilesAroundWithRadius(double latitude, double longitude, int zoomLevel, double radius, String ... expectedQuadKeys) {
        this.assertFunction(String.format("transform(bing_tiles_around(%s, %s, %s, %s), x -> bing_tile_quadkey(x))", latitude, longitude, zoomLevel, radius), (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.copyOf((Object[])expectedQuadKeys));
    }

    @Test
    public void testBingTilesAroundWithRadius() {
        this.assertBingTilesAroundWithRadius(30.12, 60.0, 1, 1000.0, "1");
        this.assertBingTilesAroundWithRadius(30.12, 60.0, 15, 0.5, "123030123010120", "123030123010121", "123030123010123");
        this.assertBingTilesAroundWithRadius(30.12, 60.0, 19, 0.05, "1230301230101212120", "1230301230101212121", "1230301230101212130", "1230301230101212103", "1230301230101212123", "1230301230101212112", "1230301230101212102");
    }

    @Test
    public void testBingTilesAroundCornerWithRadius() {
        this.assertBingTilesAroundWithRadius(-85.05112878, -180.0, 1, 500.0, "3", "2");
        this.assertBingTilesAroundWithRadius(-85.05112878, -180.0, 5, 200.0, "33332", "33333", "22222", "22223", "22220", "22221", "33330", "33331");
        this.assertBingTilesAroundWithRadius(-85.05112878, -180.0, 15, 0.2, "333333333333332", "333333333333333", "222222222222222", "222222222222223", "222222222222220", "222222222222221", "333333333333330", "333333333333331");
        this.assertBingTilesAroundWithRadius(-85.05112878, -180.0, 4, 500.0, "3323", "3332", "3333", "2222", "2223", "2232", "2220", "2221", "3330", "3331");
        this.assertBingTilesAroundWithRadius(-85.05112878, 180.0, 4, 500.0, "3323", "3332", "3333", "2222", "2223", "2232", "3331", "2221", "2220", "3330");
        this.assertBingTilesAroundWithRadius(85.05112878, -180.0, 4, 500.0, "1101", "1110", "1111", "0000", "0001", "0010", "0002", "0003", "1112", "1113");
        this.assertBingTilesAroundWithRadius(85.05112878, 180.0, 4, 500.0, "1101", "1110", "1111", "0000", "0001", "0010", "1113", "0003", "0002", "1112");
    }

    @Test
    public void testBingTilesAroundEdgeWithRadius() {
        this.assertBingTilesAroundWithRadius(-85.05112878, 0.0, 3, 300.0, "233", "322");
        this.assertBingTilesAroundWithRadius(-85.05112878, 0.0, 12, 1.0, "233333333332", "233333333333", "322222222222", "322222222223", "322222222220", "233333333331");
        this.assertBingTilesAroundWithRadius(-85.05112878, 0.0, 4, 100.0, "2333", "3222");
        this.assertBingTilesAroundWithRadius(85.05112878, 0.0, 4, 100.0, "0111", "1000");
        this.assertBingTilesAroundWithRadius(0.0, 180.0, 4, 100.0, "3111", "2000", "1333", "0222");
        this.assertBingTilesAroundWithRadius(0.0, -180.0, 4, 100.0, "3111", "2000", "0222", "1333");
    }

    @Test
    public void testBingTilesWithRadiusBadInput() {
        this.assertInvalidFunction("bing_tiles_around(30.12, 60.0, 1, -1)", "Radius must be >= 0");
        this.assertInvalidFunction("bing_tiles_around(30.12, 60.0, 1, 2000)", "Radius must be <= 1,000 km");
        this.assertInvalidFunction("bing_tiles_around(30.12, 60.0, 20, 100)", "The number of tiles covering input rectangle exceeds the limit of 1M. Number of tiles: 36699364. Radius: 100.0 km. Zoom level: 20.");
    }

    @Test
    public void testBingTilesAround() {
        this.assertFunction("transform(bing_tiles_around(30.12, 60, 1), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"0", (Object)"2", (Object)"1", (Object)"3"));
        this.assertFunction("transform(bing_tiles_around(30.12, 60, 15), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"123030123010102", (Object)"123030123010120", (Object)"123030123010122", (Object)"123030123010103", (Object)"123030123010121", (Object)"123030123010123", (Object)"123030123010112", (Object)"123030123010130", (Object)"123030123010132"));
        this.assertFunction("transform(bing_tiles_around(30.12, 60, 23), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"12303012301012121210122", (Object)"12303012301012121210300", (Object)"12303012301012121210302", (Object)"12303012301012121210123", (Object)"12303012301012121210301", (Object)"12303012301012121210303", (Object)"12303012301012121210132", (Object)"12303012301012121210310", (Object)"12303012301012121210312"));
    }

    @Test
    public void testBingTilesAroundCorner() {
        this.assertFunction("transform(bing_tiles_around(-85.05112878, -180, 1), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"0", (Object)"2", (Object)"1", (Object)"3"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, -180, 3), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"220", (Object)"222", (Object)"221", (Object)"223"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, -180, 15), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"222222222222220", (Object)"222222222222222", (Object)"222222222222221", (Object)"222222222222223"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, -180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"20", (Object)"22", (Object)"21", (Object)"23"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"30", (Object)"32", (Object)"31", (Object)"33"));
        this.assertFunction("transform(bing_tiles_around(85.05112878, -180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"00", (Object)"02", (Object)"01", (Object)"03"));
        this.assertFunction("transform(bing_tiles_around(85.05112878, 180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"10", (Object)"12", (Object)"11", (Object)"13"));
    }

    @Test
    public void testBingTilesAroundEdge() {
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 0, 1), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"0", (Object)"2", (Object)"1", (Object)"3"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 0, 3), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"231", (Object)"233", (Object)"320", (Object)"322", (Object)"321", (Object)"323"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 0, 15), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"233333333333331", (Object)"233333333333333", (Object)"322222222222220", (Object)"322222222222222", (Object)"322222222222221", (Object)"322222222222223"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 0, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"21", (Object)"23", (Object)"30", (Object)"32", (Object)"31", (Object)"33"));
        this.assertFunction("transform(bing_tiles_around(85.05112878, 0, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"01", (Object)"03", (Object)"10", (Object)"12", (Object)"11", (Object)"13"));
        this.assertFunction("transform(bing_tiles_around(0, 180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"12", (Object)"30", (Object)"32", (Object)"13", (Object)"31", (Object)"33"));
        this.assertFunction("transform(bing_tiles_around(0, -180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"02", (Object)"20", (Object)"22", (Object)"03", (Object)"21", (Object)"23"));
    }

    @Test
    public void testBingTileZoomLevel() {
        this.assertFunction("bing_tile_zoom_level(bing_tile('213'))", (Type)TinyintType.TINYINT, (byte)3);
        this.assertFunction("bing_tile_zoom_level(bing_tile('123030123010121'))", (Type)TinyintType.TINYINT, (byte)15);
    }

    @Test
    public void testBingTilePolygon() {
        this.assertFunction("ST_AsText(bing_tile_polygon(bing_tile('123030123010121')))", (Type)VarcharType.VARCHAR, "POLYGON ((59.996337890625 30.11662158281937, 60.00732421875 30.11662158281937, 60.00732421875 30.12612436422458, 59.996337890625 30.12612436422458, 59.996337890625 30.11662158281937))");
        this.assertFunction("ST_AsText(ST_Centroid(bing_tile_polygon(bing_tile('123030123010121'))))", (Type)VarcharType.VARCHAR, "POINT (60.0018310442288 30.121372968273892)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(1, 1, 1)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(3, 3, 2)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(7, 7, 3)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(15, 15, 4)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(31, 31, 5)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 1)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(1, 1, 2)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(3, 3, 3)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(7, 7, 4)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(15, 15, 5)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(1, 1, 1)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(2, 2, 2)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(4, 4, 3)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(8, 8, 4)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(16, 16, 5)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 1)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 2)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 3)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 4)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 5)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
    }

    @Test
    public void testLargeGeometryToBingTiles() throws Exception {
        Path filePath = new File(Resources.getResource((String)"large_polygon.txt").toURI()).toPath();
        List<String> lines = Files.readAllLines(filePath);
        for (String line : lines) {
            String[] parts = line.split("\\|");
            String wkt = parts[0];
            int zoomLevel = Integer.parseInt(parts[1]);
            long tileCount = Long.parseLong(parts[2]);
            this.assertFunction("cardinality(geometry_to_bing_tiles(ST_GeometryFromText('" + wkt + "'), " + zoomLevel + "))", (Type)BigintType.BIGINT, tileCount);
        }
    }

    @Test
    public void testGeometryToBingTiles() throws Exception {
        String largeWkt;
        this.assertGeometryToBingTiles("POINT (60 30.12)", 10, (List<String>)ImmutableList.of((Object)"1230301230"));
        this.assertGeometryToBingTiles("POINT (60 30.12)", 15, (List<String>)ImmutableList.of((Object)"123030123010121"));
        this.assertGeometryToBingTiles("POINT (60 30.12)", 16, (List<String>)ImmutableList.of((Object)"1230301230101212"));
        this.assertGeometryToBingTiles("POLYGON ((0 0, 0 10, 10 10, 10 0))", 6, (List<String>)ImmutableList.of((Object)"122220", (Object)"122222", (Object)"122221", (Object)"122223"));
        this.assertGeometryToBingTiles("POLYGON ((0 0, 0 10, 10 10))", 6, (List<String>)ImmutableList.of((Object)"122220", (Object)"122222", (Object)"122221"));
        this.assertGeometryToBingTiles("POLYGON ((10 10, -10 10, -20 -15, 10 10))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122"));
        this.assertGeometryToBingTiles("POLYGON ((10 10, -10 10, -20 -15, 10 10))", 6, (List<String>)ImmutableList.of((Object)"211102", (Object)"211120", (Object)"033321", (Object)"033323", (Object)"211101", (Object)"211103", (Object)"211121", (Object)"033330", (Object)"033332", (Object)"211110", (Object)"211112", (Object)"033331", (Object[])new String[]{"033333", "211111", "122220", "122222", "122221"}));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12))", 10, (List<String>)ImmutableList.of((Object)"1230301230"));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12))", 15, (List<String>)ImmutableList.of((Object)"123030123010121"));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122"));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12), POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122", (Object)"123"));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12), LINESTRING (61 31, 61.01 31.01), POLYGON EMPTY)", 15, (List<String>)ImmutableList.of((Object)"123030123010121", (Object)"123030112310200", (Object)"123030112310202", (Object)"123030112310201"));
        this.assertFunction("transform(geometry_to_bing_tiles(bing_tile_polygon(bing_tile('1230301230')), 10), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"1230301230"));
        this.assertFunction("transform(geometry_to_bing_tiles(bing_tile_polygon(bing_tile('1230301230')), 11), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"12303012300", (Object)"12303012302", (Object)"12303012301", (Object)"12303012303"));
        this.assertFunction("transform(geometry_to_bing_tiles(ST_Envelope(ST_GeometryFromText('LINESTRING (59.765625 29.84064389983442, 60.2 30.14512718337612)')), 10), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"1230301230", (Object)"1230301231"));
        this.assertGeometryToBingTiles("POINT EMPTY", 10, Collections.emptyList());
        this.assertGeometryToBingTiles("POLYGON EMPTY", 10, Collections.emptyList());
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION EMPTY", 10, Collections.emptyList());
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Point(600, 30.12), 10)", "Longitude span for the geometry must be in [-180.00, 180.00] range");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_GeometryFromText('POLYGON ((1000 10, -10 10, -20 -15))'), 10)", "Longitude span for the geometry must be in [-180.00, 180.00] range");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Point(60, 300.12), 10)", "Latitude span for the geometry must be in [-85.05, 85.05] range");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_GeometryFromText('POLYGON ((10 1000, -10 10, -20 -15))'), 10)", "Latitude span for the geometry must be in [-85.05, 85.05] range");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Point(60, 30.12), 0)", "Zoom level must be > 0");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Point(60, 30.12), 40)", "Zoom level must be <= 23");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Envelope(ST_GeometryFromText('LINESTRING (0 0, 80 80)')), 16)", "The number of tiles covering input rectangle exceeds the limit of 1M. Number of tiles: 370085804. Rectangle: xMin=0.00, yMin=0.00, xMax=80.00, yMax=80.00. Zoom level: 16.");
        this.assertFunction("cardinality(geometry_to_bing_tiles(ST_Envelope(ST_GeometryFromText('LINESTRING (0 0, 80 80)')), 5))", (Type)BigintType.BIGINT, 104L);
        String filePath = new File(Resources.getResource((String)"too_large_polygon.txt").toURI()).getPath();
        try (Stream<String> lines = Files.lines(Paths.get(filePath, new String[0]));){
            largeWkt = lines.findFirst().get();
        }
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_GeometryFromText('" + largeWkt + "'), 16)", "The zoom level is too high or the geometry is too complex to compute a set of covering Bing tiles. Please use a lower zoom level or convert the geometry to its bounding box using the ST_Envelope function.");
        this.assertFunction("cardinality(geometry_to_bing_tiles(ST_Envelope(ST_GeometryFromText('" + largeWkt + "')), 16))", (Type)BigintType.BIGINT, 19939L);
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_GeometryFromText('POLYGON ((0 0, 0 20, 20 20, 0 0))'), 20)", "The zoom level is too high to compute a set of covering Bing tiles.");
        this.assertFunction("cardinality(geometry_to_bing_tiles(ST_GeometryFromText('POLYGON ((0 0, 0 20, 20 20, 0 0))'), 14))", (Type)BigintType.BIGINT, 428787L);
    }

    private void assertGeometryToBingTiles(String wkt, int zoomLevel, List<String> expectedQuadKeys) {
        this.assertFunction(String.format("transform(geometry_to_bing_tiles(ST_GeometryFromText('%s'), %s), x -> bing_tile_quadkey(x))", wkt, zoomLevel), (Type)new ArrayType((Type)VarcharType.VARCHAR), expectedQuadKeys);
    }

    @Test
    public void testEqual() {
        this.assertFunction("bing_tile(3, 5, 3) = bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile('213') = bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile('213') = bing_tile('213')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile(3, 5, 3) = bing_tile(3, 5, 4)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') = bing_tile('2131')", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("bing_tile(3, 5, 3) <> bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') <> bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') <> bing_tile('213')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile(3, 5, 3) <> bing_tile(3, 5, 4)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile('213') <> bing_tile('2131')", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testDistinctFrom() {
        this.assertFunction("null IS DISTINCT FROM null", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile(3, 5, 3) IS DISTINCT FROM null", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("null IS DISTINCT FROM bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile(3, 5, 3) IS DISTINCT FROM bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') IS DISTINCT FROM bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') IS DISTINCT FROM bing_tile('213')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile(3, 5, 3) IS DISTINCT FROM bing_tile(3, 5, 4)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile('213') IS DISTINCT FROM bing_tile('2131')", (Type)BooleanType.BOOLEAN, true);
    }
}

