/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestEncodedPolylineFunctions
extends AbstractTestFunctions {
    @BeforeClass
    public void registerFunctions() {
        this.functionAssertions.installPlugin((Plugin)new GeoPlugin());
    }

    @Test
    public void testFromEncodedPolyline() {
        this.assertFromEncodedPolyline("", "LINESTRING EMPTY");
        this.assertFromEncodedPolyline("iiqeFjs_jV", "LINESTRING EMPTY");
        this.assertFromEncodedPolyline("_p~iF~ps|U_ulLnnqC_mqNvxq`@", "LINESTRING (-120.2 38.5, -120.95 40.7, -126.45300000000002 43.252)");
    }

    private void assertFromEncodedPolyline(String polyline, String wkt) {
        this.assertFunction(String.format("ST_AsText(from_encoded_polyline('%s'))", polyline), (Type)VarcharType.VARCHAR, wkt);
    }

    @Test
    public void testToEncodedPolyline() {
        this.assertToEncodedPolyline("LINESTRING EMPTY", "");
        this.assertToEncodedPolyline("LINESTRING (-120.2 38.5, -120.95 40.7, -126.453 43.252)", "_p~iF~ps|U_ulLnnqC_mqNvxq`@");
        this.assertToEncodedPolyline("LINESTRING (-120.2 38.5, -120.95 40.7, -126.453 43.252, -128.318 46.102)", "_p~iF~ps|U_ulLnnqC_mqNvxq`@oskPfgkJ");
        this.assertToEncodedPolyline("MULTIPOINT EMPTY", "");
        this.assertToEncodedPolyline("MULTIPOINT (-120.2 38.5)", "_p~iF~ps|U");
        this.assertToEncodedPolyline("MULTIPOINT (-120.2 38.5, -120.95 40.7, -126.453 43.252)", "_p~iF~ps|U_ulLnnqC_mqNvxq`@");
        this.assertToEncodedPolyline("MULTIPOINT (-120.2 38.5, -120.95 40.7, -126.453 43.252, -128.318 46.102)", "_p~iF~ps|U_ulLnnqC_mqNvxq`@oskPfgkJ");
        this.assertInvalidFunction("to_encoded_polyline(ST_GeometryFromText('POINT (-120.2 38.5)'))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("to_encoded_polyline(ST_GeometryFromText('MULTILINESTRING ((-122.39174 37.77701))'))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    private void assertToEncodedPolyline(String wkt, String polyline) {
        this.assertFunction(String.format("to_encoded_polyline(ST_GeometryFromText('%s'))", wkt), (Type)VarcharType.VARCHAR, polyline);
    }
}

