/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.plugin.geospatial.SphericalGeographyType;
import io.trino.spi.Plugin;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExtractSpatialJoins;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleAssert;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Map;
import org.testng.annotations.Test;

public class TestExtractSpatialInnerJoin
extends BaseRuleTest {
    public TestExtractSpatialInnerJoin() {
        super(new Plugin[]{new GeoPlugin()});
    }

    @Test
    public void testDoesNotFire() {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText('POLYGON ...'), b)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[]{p.symbol("b")}), new JoinNode.EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), point) OR name_1 != name_2"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR), p.symbol("name_1")}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)GeometryType.GEOMETRY), p.symbol("name_2")}), new JoinNode.EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"NOT ST_Contains(ST_GeometryFromText(wkt), point)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR), p.symbol("name_1")}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)GeometryType.GEOMETRY), p.symbol("name_2")}), new JoinNode.EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Distance(a, b) > 5"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("a", (Type)GeometryType.GEOMETRY)}), (PlanNode)p.values(new Symbol[]{p.symbol("b", (Type)GeometryType.GEOMETRY)}), new JoinNode.EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Distance(a, b) < 5"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("a", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), (PlanNode)p.values(new Symbol[]{p.symbol("b", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), new JoinNode.EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(polygon, point)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("polygon", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), new JoinNode.EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Distance(to_spherical_geography(ST_GeometryFromText(wkt)), point) < 5"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), new JoinNode.EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(to_spherical_geography(ST_GeometryFromText(wkt)), point)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), new JoinNode.EquiJoinClause[0]))).doesNotFire();
    }

    @Test
    public void testDistanceQueries() {
        this.testSimpleDistanceQuery("ST_Distance(a, b) <= r", "ST_Distance(a, b) <= r");
        this.testSimpleDistanceQuery("ST_Distance(b, a) <= r", "ST_Distance(b, a) <= r");
        this.testSimpleDistanceQuery("r >= ST_Distance(a, b)", "ST_Distance(a, b) <= r");
        this.testSimpleDistanceQuery("r >= ST_Distance(b, a)", "ST_Distance(b, a) <= r");
        this.testSimpleDistanceQuery("ST_Distance(a, b) < r", "ST_Distance(a, b) < r");
        this.testSimpleDistanceQuery("ST_Distance(b, a) < r", "ST_Distance(b, a) < r");
        this.testSimpleDistanceQuery("r > ST_Distance(a, b)", "ST_Distance(a, b) < r");
        this.testSimpleDistanceQuery("r > ST_Distance(b, a)", "ST_Distance(b, a) < r");
        this.testSimpleDistanceQuery("ST_Distance(a, b) <= r AND name_a != name_b", "ST_Distance(a, b) <= r AND name_a != name_b");
        this.testSimpleDistanceQuery("r > ST_Distance(a, b) AND name_a != name_b", "ST_Distance(a, b) < r AND name_a != name_b");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) <= decimal '1.2'", "ST_Distance(a, b) <= radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(b, a) <= decimal '1.2'", "ST_Distance(b, a) <= radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' >= ST_Distance(a, b)", "ST_Distance(a, b) <= radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' >= ST_Distance(b, a)", "ST_Distance(b, a) <= radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) < decimal '1.2'", "ST_Distance(a, b) < radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(b, a) < decimal '1.2'", "ST_Distance(b, a) < radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' > ST_Distance(a, b)", "ST_Distance(a, b) < radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' > ST_Distance(b, a)", "ST_Distance(b, a) < radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) <= decimal '1.2' AND name_a != name_b", "ST_Distance(a, b) <= radius AND name_a != name_b", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' > ST_Distance(a, b) AND name_a != name_b", "ST_Distance(a, b) < radius AND name_a != name_b", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) <= 2 * r", "ST_Distance(a, b) <= radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(b, a) <= 2 * r", "ST_Distance(b, a) <= radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r >= ST_Distance(a, b)", "ST_Distance(a, b) <= radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r >= ST_Distance(b, a)", "ST_Distance(b, a) <= radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) < 2 * r", "ST_Distance(a, b) < radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(b, a) < 2 * r", "ST_Distance(b, a) < radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r > ST_Distance(a, b)", "ST_Distance(a, b) < radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r > ST_Distance(b, a)", "ST_Distance(b, a) < radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) <= 2 * r AND name_a != name_b", "ST_Distance(a, b) <= radius AND name_a != name_b", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r > ST_Distance(a, b) AND name_a != name_b", "ST_Distance(a, b) < radius AND name_a != name_b", "2 * r");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) <= 5", "ST_Distance(point_a, point_b) <= radius", "5");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a)) <= 5", "ST_Distance(point_b, point_a) <= radius", "5");
        this.testPointExpressionsInDistanceQuery("5 >= ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b))", "ST_Distance(point_a, point_b) <= radius", "5");
        this.testPointExpressionsInDistanceQuery("5 >= ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a))", "ST_Distance(point_b, point_a) <= radius", "5");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) < 5", "ST_Distance(point_a, point_b) < radius", "5");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a)) < 5", "ST_Distance(point_b, point_a) < radius", "5");
        this.testPointExpressionsInDistanceQuery("5 > ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b))", "ST_Distance(point_a, point_b) < radius", "5");
        this.testPointExpressionsInDistanceQuery("5 > ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a))", "ST_Distance(point_b, point_a) < radius", "5");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) <= 5 AND name_a != name_b", "ST_Distance(point_a, point_b) <= radius AND name_a != name_b", "5");
        this.testPointExpressionsInDistanceQuery("5 > ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) AND name_a != name_b", "ST_Distance(point_a, point_b) < radius AND name_a != name_b", "5");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) <= 500 / (111000 * cos(lat_b))", "ST_Distance(point_a, point_b) <= radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a)) <= 500 / (111000 * cos(lat_b))", "ST_Distance(point_b, point_a) <= radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) >= ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b))", "ST_Distance(point_a, point_b) <= radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) >= ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a))", "ST_Distance(point_b, point_a) <= radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) < 500 / (111000 * cos(lat_b))", "ST_Distance(point_a, point_b) < radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a)) < 500 / (111000 * cos(lat_b))", "ST_Distance(point_b, point_a) < radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) > ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b))", "ST_Distance(point_a, point_b) < radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) > ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a))", "ST_Distance(point_b, point_a) < radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) <= 500 / (111000 * cos(lat_b)) AND name_a != name_b", "ST_Distance(point_a, point_b) <= radius AND name_a != name_b", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) > ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) AND name_a != name_b", "ST_Distance(point_a, point_b) < radius AND name_a != name_b", "500 / (111000 * cos(lat_b))");
    }

    private void testSimpleDistanceQuery(String filter, String newFilter) {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)filter), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("a", (Type)GeometryType.GEOMETRY), p.symbol("name_a")}), (PlanNode)p.values(new Symbol[]{p.symbol("b", (Type)GeometryType.GEOMETRY), p.symbol("name_b"), p.symbol("r")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)newFilter, (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"a", (Object)0, (Object)"name_a", (Object)1)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"b", (Object)0, (Object)"name_b", (Object)1, (Object)"r", (Object)2))));
    }

    private void testRadiusExpressionInDistanceQuery(String filter, String newFilter, String radiusExpression) {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)filter), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("a", (Type)GeometryType.GEOMETRY), p.symbol("name_a")}), (PlanNode)p.values(new Symbol[]{p.symbol("b", (Type)GeometryType.GEOMETRY), p.symbol("name_b"), p.symbol("r")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)newFilter, (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"a", (Object)0, (Object)"name_a", (Object)1)), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"radius", (Object)PlanMatchPattern.expression((String)radiusExpression)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"b", (Object)0, (Object)"name_b", (Object)1, (Object)"r", (Object)2)))));
    }

    private void testPointExpressionsInDistanceQuery(String filter, String newFilter, String radiusExpression) {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)filter), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("lat_a"), p.symbol("lng_a"), p.symbol("name_a")}), (PlanNode)p.values(new Symbol[]{p.symbol("lat_b"), p.symbol("lng_b"), p.symbol("name_b")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)newFilter, (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"point_a", (Object)PlanMatchPattern.expression((String)"ST_Point(lng_a, lat_a)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat_a", (Object)0, (Object)"lng_a", (Object)1, (Object)"name_a", (Object)2))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"point_b", (Object)PlanMatchPattern.expression((String)"ST_Point(lng_b, lat_b)")), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"radius", (Object)PlanMatchPattern.expression((String)radiusExpression)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat_b", (Object)0, (Object)"lng_b", (Object)1, (Object)"name_b", (Object)2))))));
    }

    private void testPointAndRadiusExpressionsInDistanceQuery(String filter, String newFilter, String radiusExpression) {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)filter), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("lat_a"), p.symbol("lng_a"), p.symbol("name_a")}), (PlanNode)p.values(new Symbol[]{p.symbol("lat_b"), p.symbol("lng_b"), p.symbol("name_b")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)newFilter, (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"point_a", (Object)PlanMatchPattern.expression((String)"ST_Point(lng_a, lat_a)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat_a", (Object)0, (Object)"lng_a", (Object)1, (Object)"name_a", (Object)2))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"point_b", (Object)PlanMatchPattern.expression((String)"ST_Point(lng_b, lat_b)")), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"radius", (Object)PlanMatchPattern.expression((String)radiusExpression)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat_b", (Object)0, (Object)"lng_b", (Object)1, (Object)"name_b", (Object)2))))));
    }

    @Test
    public void testConvertToSpatialJoin() {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(a, b)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("a")}), (PlanNode)p.values(new Symbol[]{p.symbol("b")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)"ST_Contains(a, b)", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"a", (Object)0)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"b", (Object)0))));
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"name_1 != name_2 AND ST_Contains(a, b)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("a"), p.symbol("name_1")}), (PlanNode)p.values(new Symbol[]{p.symbol("b"), p.symbol("name_2")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)"name_1 != name_2 AND ST_Contains(a, b)", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"a", (Object)0, (Object)"name_1", (Object)1)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"b", (Object)0, (Object)"name_2", (Object)1))));
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(a1, b1) AND ST_Contains(a2, b2)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("a1"), p.symbol("a2")}), (PlanNode)p.values(new Symbol[]{p.symbol("b1"), p.symbol("b2")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)"ST_Contains(a1, b1) AND ST_Contains(a2, b2)", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"a1", (Object)0, (Object)"a2", (Object)1)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"b1", (Object)0, (Object)"b2", (Object)1))));
    }

    @Test
    public void testPushDownFirstArgument() {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), point)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)GeometryType.GEOMETRY)}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)"ST_Contains(st_geometryfromtext, point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt", (Object)0))), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"point", (Object)0))));
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), ST_Point(0, 0))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[0]), new JoinNode.EquiJoinClause[0]))).doesNotFire();
    }

    @Test
    public void testPushDownSecondArgument() {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(polygon, ST_Point(lng, lat))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("polygon", (Type)GeometryType.GEOMETRY)}), (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)"ST_Contains(polygon, st_point)", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"polygon", (Object)0)), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1)))));
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText('POLYGON ...'), ST_Point(lng, lat))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng")}), new JoinNode.EquiJoinClause[0]))).doesNotFire();
    }

    @Test
    public void testPushDownBothArguments() {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)"ST_Contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt", (Object)0))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1)))));
    }

    @Test
    public void testPushDownOppositeOrder() {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng")}), (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)"ST_Contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt", (Object)0)))));
    }

    @Test
    public void testPushDownAnd() {
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"name_1 != name_2 AND ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR), p.symbol("name_1")}), (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng"), p.symbol("name_2")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)"name_1 != name_2 AND ST_Contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt", (Object)0, (Object)"name_1", (Object)1))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1, (Object)"name_2", (Object)2)))));
        this.assertRuleApplication().on(p -> p.filter(PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt1), geometry1) AND ST_Contains(ST_GeometryFromText(wkt2), geometry2)"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[]{p.symbol("wkt1", (Type)VarcharType.VARCHAR), p.symbol("wkt2", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("geometry1"), p.symbol("geometry2")}), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin((String)"ST_Contains(st_geometryfromtext, geometry1) AND ST_Contains(ST_GeometryFromText(wkt2), geometry2)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt1)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt1", (Object)0, (Object)"wkt2", (Object)1))), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"geometry1", (Object)0, (Object)"geometry2", (Object)1))));
    }

    private RuleAssert assertRuleApplication() {
        RuleTester tester = this.tester();
        return tester.assertThat((Rule)new ExtractSpatialJoins.ExtractSpatialInnerJoin(tester.getPlannerContext(), tester.getSplitManager(), tester.getPageSourceManager(), tester.getTypeAnalyzer()));
    }
}

