/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.plugin.geospatial.SphericalGeographyType;
import io.trino.spi.Plugin;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExtractSpatialJoins;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleAssert;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Map;
import org.testng.annotations.Test;

public class TestExtractSpatialLeftJoin
extends BaseRuleTest {
    public TestExtractSpatialLeftJoin() {
        super(new Plugin[]{new GeoPlugin()});
    }

    @Test
    public void testDoesNotFire() {
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[]{p.symbol("b")}), PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText('POLYGON ...'), b)"), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR), p.symbol("name_1")}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)GeometryType.GEOMETRY), p.symbol("name_2")}), PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), point) OR name_1 != name_2"), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR), p.symbol("name_1")}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)GeometryType.GEOMETRY), p.symbol("name_2")}), PlanBuilder.expression((String)"NOT ST_Contains(ST_GeometryFromText(wkt), point)"), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("a", (Type)GeometryType.GEOMETRY)}), (PlanNode)p.values(new Symbol[]{p.symbol("b", (Type)GeometryType.GEOMETRY)}), PlanBuilder.expression((String)"ST_Distance(a, b) > 5"), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("a", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), (PlanNode)p.values(new Symbol[]{p.symbol("b", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), PlanBuilder.expression((String)"ST_Distance(a, b) < 5"), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("polygon", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), PlanBuilder.expression((String)"ST_Contains(polygon, point)"), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), PlanBuilder.expression((String)"ST_Distance(to_spherical_geography(ST_GeometryFromText(wkt)), point) < 5"), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)}), PlanBuilder.expression((String)"ST_Contains(to_spherical_geography(ST_GeometryFromText(wkt)), point)"), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testConvertToSpatialJoin() {
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("a")}), (PlanNode)p.values(new Symbol[]{p.symbol("b")}), PlanBuilder.expression((String)"ST_Contains(a, b)"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin((String)"ST_Contains(a, b)", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"a", (Object)0)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"b", (Object)0))));
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("a"), p.symbol("name_1")}), (PlanNode)p.values(new Symbol[]{p.symbol("b"), p.symbol("name_2")}), PlanBuilder.expression((String)"name_1 != name_2 AND ST_Contains(a, b)"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin((String)"name_1 != name_2 AND ST_Contains(a, b)", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"a", (Object)0, (Object)"name_1", (Object)1)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"b", (Object)0, (Object)"name_2", (Object)1))));
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("a1"), p.symbol("a2")}), (PlanNode)p.values(new Symbol[]{p.symbol("b1"), p.symbol("b2")}), PlanBuilder.expression((String)"ST_Contains(a1, b1) AND ST_Contains(a2, b2)"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin((String)"ST_Contains(a1, b1) AND ST_Contains(a2, b2)", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"a1", (Object)0, (Object)"a2", (Object)1)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"b1", (Object)0, (Object)"b2", (Object)1))));
    }

    @Test
    public void testPushDownFirstArgument() {
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("point", (Type)GeometryType.GEOMETRY)}), PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), point)"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin((String)"ST_Contains(st_geometryfromtext, point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt", (Object)0))), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"point", (Object)0))));
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[0]), PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), ST_Point(0, 0))"), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testPushDownSecondArgument() {
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("polygon", (Type)GeometryType.GEOMETRY)}), (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng")}), PlanBuilder.expression((String)"ST_Contains(polygon, ST_Point(lng, lat))"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin((String)"ST_Contains(polygon, st_point)", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"polygon", (Object)0)), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1)))));
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng")}), PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText('POLYGON ...'), ST_Point(lng, lat))"), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testPushDownBothArguments() {
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng")}), PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin((String)"ST_Contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt", (Object)0))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1)))));
    }

    @Test
    public void testPushDownOppositeOrder() {
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng")}), (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR)}), PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin((String)"ST_Contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt", (Object)0)))));
    }

    @Test
    public void testPushDownAnd() {
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("wkt", (Type)VarcharType.VARCHAR), p.symbol("name_1")}), (PlanNode)p.values(new Symbol[]{p.symbol("lat"), p.symbol("lng"), p.symbol("name_2")}), PlanBuilder.expression((String)"name_1 != name_2 AND ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin((String)"name_1 != name_2 AND ST_Contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt", (Object)0, (Object)"name_1", (Object)1))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1, (Object)"name_2", (Object)2)))));
        this.assertRuleApplication().on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new Symbol[]{p.symbol("wkt1", (Type)VarcharType.VARCHAR), p.symbol("wkt2", (Type)VarcharType.VARCHAR)}), (PlanNode)p.values(new Symbol[]{p.symbol("geometry1"), p.symbol("geometry2")}), PlanBuilder.expression((String)"ST_Contains(ST_GeometryFromText(wkt1), geometry1) AND ST_Contains(ST_GeometryFromText(wkt2), geometry2)"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.spatialLeftJoin((String)"ST_Contains(st_geometryfromtext, geometry1) AND ST_Contains(ST_GeometryFromText(wkt2), geometry2)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(wkt1)")), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"wkt1", (Object)0, (Object)"wkt2", (Object)1))), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"geometry1", (Object)0, (Object)"geometry2", (Object)1))));
    }

    private RuleAssert assertRuleApplication() {
        RuleTester tester = this.tester();
        return this.tester().assertThat((Rule)new ExtractSpatialJoins.ExtractSpatialLeftJoin(tester.getPlannerContext(), tester.getSplitManager(), tester.getPageSourceManager(), tester.getTypeAnalyzer()));
    }
}

