/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.plugin.geospatial.SphericalGeographyType;
import io.trino.spi.Plugin;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestGeoSpatialQueries
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).build();
        try {
            queryRunner.installPlugin((Plugin)new GeoPlugin());
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    @Test
    public void testGeometryResult() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT ST_Point(52.233, 21.016)"))).matches(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{GeometryType.GEOMETRY}).row(new Object[]{"POINT (52.233 21.016)"}).build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT ST_GeometryFromText('POLYGON((0 0, 0 1, 1 1, 1 1, 1 0, 0 0))')"))).matches(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{GeometryType.GEOMETRY}).row(new Object[]{"POLYGON ((0 0, 1 0, 1 1, 1 1, 0 1, 0 0))"}).build());
    }

    @Test
    public void testSphericalGeographyResult() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT to_spherical_geography(ST_GeometryFromText('POLYGON((0 0, 0 1, 1 1, 1 1, 1 0, 0 0))'))"))).matches(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{SphericalGeographyType.SPHERICAL_GEOGRAPHY}).row(new Object[]{"POLYGON ((0 0, 1 0, 1 1, 1 1, 0 1, 0 0))"}).build());
    }
}

