/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.collect.ImmutableList;
import io.trino.geospatial.KdbTree;
import io.trino.geospatial.KdbTreeUtils;
import io.trino.geospatial.Rectangle;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestKdbTreeCasts
extends AbstractTestFunctions {
    @BeforeClass
    public void registerFunctions() {
        this.functionAssertions.installPlugin((Plugin)new GeoPlugin());
    }

    @Test
    public void test() {
        String kdbTreeJson = this.makeKdbTreeJson();
        this.assertFunction(String.format("typeof(cast('%s' AS KdbTree))", kdbTreeJson), (Type)VarcharType.VARCHAR, "KdbTree");
        this.assertFunction(String.format("typeof(cast('%s' AS KDBTree))", kdbTreeJson), (Type)VarcharType.VARCHAR, "KdbTree");
        this.assertFunction(String.format("typeof(cast('%s' AS kdbTree))", kdbTreeJson), (Type)VarcharType.VARCHAR, "KdbTree");
        this.assertFunction(String.format("typeof(cast('%s' AS kdbtree))", kdbTreeJson), (Type)VarcharType.VARCHAR, "KdbTree");
        this.assertInvalidCast("typeof(cast('' AS KdbTree))", "Invalid JSON string for KDB tree");
    }

    private String makeKdbTreeJson() {
        ImmutableList.Builder rectangles = ImmutableList.builder();
        for (double x = 0.0; x < 10.0; x += 1.0) {
            for (double y = 0.0; y < 5.0; y += 1.0) {
                rectangles.add((Object)new Rectangle(x, y, x + 1.0, y + 2.0));
            }
        }
        return KdbTreeUtils.toJson((KdbTree)KdbTree.buildKdbTree((int)100, (Rectangle)new Rectangle(0.0, 0.0, 9.0, 4.0), (List)rectangles.build()));
    }
}

