/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.spi.Plugin;
import io.trino.spi.type.IntegerType;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RewriteSpatialPartitioningAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleAssert;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRewriteSpatialPartitioningAggregation
extends BaseRuleTest {
    public TestRewriteSpatialPartitioningAggregation() {
        super(new Plugin[]{new GeoPlugin()});
    }

    @Test
    public void testDoesNotFire() {
        this.assertRuleApplication().on(p -> p.aggregation(a -> a.globalGrouping().step(AggregationNode.Step.SINGLE).addAggregation(p.symbol("sp"), PlanBuilder.expression((String)"spatial_partitioning(geometry, n)"), (List)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)IntegerType.INTEGER)).source((PlanNode)p.values(new Symbol[]{p.symbol("geometry"), p.symbol("n")})))).doesNotFire();
    }

    @Test
    public void test() {
        this.assertRuleApplication().on(p -> p.aggregation(a -> a.globalGrouping().step(AggregationNode.Step.SINGLE).addAggregation(p.symbol("sp"), PlanBuilder.expression((String)"spatial_partitioning(geometry)"), (List)ImmutableList.of((Object)GeometryType.GEOMETRY)).source((PlanNode)p.values(new Symbol[]{p.symbol("geometry")})))).matches(PlanMatchPattern.aggregation((Map)ImmutableMap.of((Object)"sp", (Object)PlanMatchPattern.functionCall((String)"spatial_partitioning", (List)ImmutableList.of((Object)"envelope", (Object)"partition_count"))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"partition_count", (Object)PlanMatchPattern.expression((String)"100"), (Object)"envelope", (Object)PlanMatchPattern.expression((String)"ST_Envelope(geometry)")), (PlanMatchPattern)PlanMatchPattern.values((String[])new String[]{"geometry"}))));
        this.assertRuleApplication().on(p -> p.aggregation(a -> a.globalGrouping().step(AggregationNode.Step.SINGLE).addAggregation(p.symbol("sp"), PlanBuilder.expression((String)"spatial_partitioning(envelope)"), (List)ImmutableList.of((Object)GeometryType.GEOMETRY)).source((PlanNode)p.values(new Symbol[]{p.symbol("envelope")})))).matches(PlanMatchPattern.aggregation((Map)ImmutableMap.of((Object)"sp", (Object)PlanMatchPattern.functionCall((String)"spatial_partitioning", (List)ImmutableList.of((Object)"envelope", (Object)"partition_count"))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"partition_count", (Object)PlanMatchPattern.expression((String)"100"), (Object)"envelope", (Object)PlanMatchPattern.expression((String)"ST_Envelope(geometry)")), (PlanMatchPattern)PlanMatchPattern.values((String[])new String[]{"geometry"}))));
    }

    private RuleAssert assertRuleApplication() {
        return this.tester().assertThat((Rule)new RewriteSpatialPartitioningAggregation(this.tester().getPlannerContext()));
    }
}

