/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.geospatial.KdbTree;
import io.trino.geospatial.KdbTreeUtils;
import io.trino.geospatial.Rectangle;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesSpatialIndexFactory;
import io.trino.operator.PipelineContext;
import io.trino.operator.SpatialIndexBuilderOperator;
import io.trino.operator.SpatialJoinOperator;
import io.trino.operator.TaskContext;
import io.trino.operator.ValuesOperator;
import io.trino.operator.join.InternalJoinFilterFunction;
import io.trino.operator.join.StandardJoinFilterFunction;
import io.trino.plugin.geospatial.GeoFunctions;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSpatialJoinOperator {
    private static final String KDB_TREE_JSON = KdbTreeUtils.toJson((KdbTree)new KdbTree(KdbTree.Node.newInternal((Rectangle)new Rectangle(-2.0, -2.0, 15.0, 15.0), (KdbTree.Node)KdbTree.Node.newInternal((Rectangle)new Rectangle(-2.0, -2.0, 6.0, 15.0), (KdbTree.Node)KdbTree.Node.newLeaf((Rectangle)new Rectangle(-2.0, -2.0, 6.0, 1.0), (int)1), (KdbTree.Node)KdbTree.Node.newLeaf((Rectangle)new Rectangle(-2.0, 1.0, 6.0, 15.0), (int)2)), (KdbTree.Node)KdbTree.Node.newLeaf((Rectangle)new Rectangle(6.0, -2.0, 15.0, 15.0), (int)0))));
    private static final Slice POLYGON_A = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((0 0, -0.5 2.5, 0 5, 2.5 5.5, 5 5, 5.5 2.5, 5 0, 2.5 -0.5, 0 0))"));
    private static final Slice POLYGON_B = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((4 4, 3.5 7, 4 10, 7 10.5, 10 10, 10.5 7, 10 4, 7 3.5, 4 4))"));
    private static final Slice POINT_X = GeoFunctions.stPoint((double)1.0, (double)1.0);
    private static final Slice POINT_Y = GeoFunctions.stPoint((double)4.5, (double)4.5);
    private static final Slice POINT_Z = GeoFunctions.stPoint((double)6.0, (double)6.0);
    private static final Slice POINT_W = GeoFunctions.stPoint((double)20.0, (double)20.0);
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeMethod
    public void setUp() {
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.daemonThreadsNamed((String)"test-executor-%s"), new ThreadPoolExecutor.DiscardPolicy());
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testSpatialJoin() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{POLYGON_A, "A"}).row(new Object[]{null, "null"}).pageBreak().row(new Object[]{POLYGON_B, "B"});
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{POINT_X, "x"}).row(new Object[]{null, "null"}).row(new Object[]{POINT_Y, "y"}).pageBreak().row(new Object[]{POINT_Z, "z"}).pageBreak().row(new Object[]{POINT_W, "w"});
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"x", "A"}).row(new Object[]{"y", "A"}).row(new Object[]{"y", "B"}).row(new Object[]{"z", "B"}).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.INNER, buildPages, probePages, expected);
    }

    @Test
    public void testSpatialLeftJoin() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{POLYGON_A, "A"}).row(new Object[]{null, "null"}).pageBreak().row(new Object[]{POLYGON_B, "B"});
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{POINT_X, "x"}).row(new Object[]{null, "null"}).row(new Object[]{POINT_Y, "y"}).pageBreak().row(new Object[]{POINT_Z, "z"}).pageBreak().row(new Object[]{POINT_W, "w"});
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"x", "A"}).row(new Object[]{"null", null}).row(new Object[]{"y", "A"}).row(new Object[]{"y", "B"}).row(new Object[]{"z", "B"}).row(new Object[]{"w", null}).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.LEFT, buildPages, probePages, expected);
    }

    private void assertSpatialJoin(TaskContext taskContext, SpatialJoinNode.Type joinType, RowPagesBuilder buildPages, RowPagesBuilder probePages, MaterializedResult expected) {
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.contains(probe), Optional.empty(), Optional.empty(), buildPages);
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), joinType, probePages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.empty(), pagesSpatialIndexFactory);
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, (DriverContext)driverContext, (List)probePages.build(), (MaterializedResult)expected);
    }

    @Test
    public void testEmptyBuild() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR));
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{POINT_X, "x"}).row(new Object[]{null, "null"}).row(new Object[]{POINT_Y, "y"}).pageBreak().row(new Object[]{POINT_Z, "z"}).pageBreak().row(new Object[]{POINT_W, "w"});
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.INNER, buildPages, probePages, expected);
    }

    @Test
    public void testEmptyBuildLeftJoin() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR));
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{POINT_X, "x"}).row(new Object[]{null, "null"}).row(new Object[]{POINT_Y, "y"}).pageBreak().row(new Object[]{POINT_Z, "z"}).pageBreak().row(new Object[]{POINT_W, "w"});
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"x", null}).row(new Object[]{"null", null}).row(new Object[]{"y", null}).row(new Object[]{"z", null}).row(new Object[]{"w", null}).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.LEFT, buildPages, probePages, expected);
    }

    @Test
    public void testEmptyProbe() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{POLYGON_A, "A"}).row(new Object[]{null, "null"}).pageBreak().row(new Object[]{POLYGON_B, "B"});
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.INNER, buildPages, probePages, expected);
    }

    @Test
    public void testYield() {
        int i;
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        AtomicInteger filterFunctionCalls = new AtomicInteger();
        TestInternalJoinFilterFunction filterFunction = new TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> {
            filterFunctionCalls.incrementAndGet();
            driverContext.getYieldSignal().forceYieldForTesting();
            return true;
        });
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{POLYGON_A, "A"}).pageBreak().row(new Object[]{POLYGON_B, "B"});
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.contains(probe), Optional.empty(), Optional.of(filterFunction), buildPages);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR));
        for (i = 0; i < 10; ++i) {
            probePages.row(new Object[]{GeoFunctions.stPoint((double)(1.0 + 0.1 * (double)i), (double)(1.0 + 0.1 * (double)i)), "x" + i});
        }
        for (i = 0; i < 10; ++i) {
            probePages.row(new Object[]{GeoFunctions.stPoint((double)(4.5 + 0.01 * (double)i), (double)(4.5 + 0.01 * (double)i)), "y" + i});
        }
        for (i = 0; i < 10; ++i) {
            probePages.row(new Object[]{GeoFunctions.stPoint((double)(6.0 + 0.1 * (double)i), (double)(6.0 + 0.1 * (double)i)), "z" + i});
        }
        List probeInput = probePages.build();
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), SpatialJoinNode.Type.INNER, probePages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.empty(), pagesSpatialIndexFactory);
        Operator operator = joinOperatorFactory.createOperator(driverContext);
        Assert.assertTrue((boolean)operator.needsInput());
        operator.addInput((Page)probeInput.get(0));
        operator.finish();
        for (int i2 = 0; i2 < 40; ++i2) {
            driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
            Assert.assertNull((Object)operator.getOutput());
            Assert.assertEquals((int)filterFunctionCalls.get(), (int)(i2 + 1), (String)"Expected join to stop processing (yield) after calling filter function once");
            driverContext.getYieldSignal().reset();
        }
        driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
        Page output = operator.getOutput();
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((int)output.getPositionCount(), (int)40);
    }

    @Test(dataProvider="testDuplicateProbeFactoryDataProvider")
    public void testDuplicateProbeFactory(boolean createSecondaryOperators) throws Exception {
        TaskContext taskContext = this.createTaskContext();
        PipelineContext pipelineContext = taskContext.addPipelineContext(0, true, true, false);
        DriverContext probeDriver = pipelineContext.addDriverContext();
        DriverContext buildDriver = pipelineContext.addDriverContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE)).row(new Object[]{GeoFunctions.stPoint((double)0.0, (double)0.0), "0_0", 1.5});
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(buildDriver, (build, probe, r) -> build.distance(probe) <= r.getAsDouble(), Optional.of(2), Optional.empty(), buildPages);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{GeoFunctions.stPoint((double)0.0, (double)1.0), "0_1"});
        SpatialJoinOperator.SpatialJoinOperatorFactory firstFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), SpatialJoinNode.Type.INNER, probePages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.empty(), pagesSpatialIndexFactory);
        for (int i = 0; i < 3; ++i) {
            DriverContext secondDriver = pipelineContext.addDriverContext();
            OperatorFactory secondFactory = firstFactory.duplicate();
            if (createSecondaryOperators) {
                try (Operator secondOperator = secondFactory.createOperator(secondDriver);){
                    Assert.assertEquals((Collection)OperatorAssertion.toPages((Operator)secondOperator, Collections.emptyIterator()), (Collection)ImmutableList.of());
                }
            }
            secondFactory.noMoreOperators();
        }
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"0_1", "0_0"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)firstFactory, (DriverContext)probeDriver, (List)probePages.build(), (MaterializedResult)expected);
    }

    @DataProvider
    public Object[][] testDuplicateProbeFactoryDataProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test
    public void testDistanceQuery() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE)).row(new Object[]{GeoFunctions.stPoint((double)0.0, (double)0.0), "0_0", 1.5}).row(new Object[]{null, "null", 1.5}).row(new Object[]{GeoFunctions.stPoint((double)1.0, (double)0.0), "1_0", 1.5}).pageBreak().row(new Object[]{GeoFunctions.stPoint((double)3.0, (double)0.0), "3_0", 1.5}).pageBreak().row(new Object[]{GeoFunctions.stPoint((double)10.0, (double)0.0), "10_0", 1.5});
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.distance(probe) <= r.getAsDouble(), Optional.of(2), Optional.empty(), buildPages);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(new Object[]{GeoFunctions.stPoint((double)0.0, (double)1.0), "0_1"}).row(new Object[]{null, "null"}).row(new Object[]{GeoFunctions.stPoint((double)1.0, (double)1.0), "1_1"}).pageBreak().row(new Object[]{GeoFunctions.stPoint((double)3.0, (double)1.0), "3_1"}).pageBreak().row(new Object[]{GeoFunctions.stPoint((double)10.0, (double)1.0), "10_1"});
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), SpatialJoinNode.Type.INNER, probePages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.empty(), pagesSpatialIndexFactory);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"0_1", "0_0"}).row(new Object[]{"0_1", "1_0"}).row(new Object[]{"1_1", "0_0"}).row(new Object[]{"1_1", "1_0"}).row(new Object[]{"3_1", "3_0"}).row(new Object[]{"10_1", "10_0"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, (DriverContext)driverContext, (List)probePages.build(), (MaterializedResult)expected);
    }

    @Test
    public void testDistributedSpatialJoin() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, true).addDriverContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).row(new Object[]{POLYGON_A, "A", 1}).row(new Object[]{POLYGON_A, "A", 2}).row(new Object[]{null, "null", null}).pageBreak().row(new Object[]{POLYGON_B, "B", 0}).row(new Object[]{POLYGON_B, "B", 2});
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).row(new Object[]{POINT_X, "x", 2}).row(new Object[]{null, "null", null}).row(new Object[]{POINT_Y, "y", 2}).pageBreak().row(new Object[]{POINT_Z, "z", 0});
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"x", "A"}).row(new Object[]{"y", "A"}).row(new Object[]{"y", "B"}).row(new Object[]{"z", "B"}).build();
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.contains(probe), Optional.empty(), Optional.of(2), Optional.of(KDB_TREE_JSON), Optional.empty(), buildPages);
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), SpatialJoinNode.Type.INNER, probePages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.of(2), pagesSpatialIndexFactory);
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, (DriverContext)driverContext, (List)probePages.build(), (MaterializedResult)expected);
    }

    @Test
    public void testDistributedSpatialSelfJoin() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, true).addDriverContext();
        RowPagesBuilder pages = RowPagesBuilder.rowPagesBuilder((Iterable)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).row(new Object[]{POLYGON_A, "A", 1}).row(new Object[]{POLYGON_A, "A", 2}).row(new Object[]{null, "null", null}).pageBreak().row(new Object[]{POLYGON_B, "B", 0}).row(new Object[]{POLYGON_B, "B", 2});
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"A", "A"}).row(new Object[]{"A", "B"}).row(new Object[]{"B", "A"}).row(new Object[]{"B", "B"}).build();
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.intersects(probe), Optional.empty(), Optional.of(2), Optional.of(KDB_TREE_JSON), Optional.empty(), pages);
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), SpatialJoinNode.Type.INNER, pages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.of(2), pagesSpatialIndexFactory);
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, (DriverContext)driverContext, (List)pages.build(), (MaterializedResult)expected);
    }

    private PagesSpatialIndexFactory buildIndex(DriverContext driverContext, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Integer> radiusChannel, Optional<InternalJoinFilterFunction> filterFunction, RowPagesBuilder buildPages) {
        return this.buildIndex(driverContext, spatialRelationshipTest, radiusChannel, Optional.empty(), Optional.empty(), filterFunction, buildPages);
    }

    private PagesSpatialIndexFactory buildIndex(DriverContext driverContext, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel, Optional<String> kdbTreeJson, Optional<InternalJoinFilterFunction> filterFunction, RowPagesBuilder buildPages) {
        Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = filterFunction.map(function -> (session, addresses, pages) -> new StandardJoinFilterFunction(function, addresses, pages));
        ValuesOperator.ValuesOperatorFactory valuesOperatorFactory = new ValuesOperator.ValuesOperatorFactory(0, new PlanNodeId("test"), buildPages.build());
        SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory buildOperatorFactory = new SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory(1, new PlanNodeId("test"), buildPages.getTypes(), Ints.asList((int[])new int[]{1}), 0, radiusChannel, partitionChannel, spatialRelationshipTest, kdbTreeJson, filterFunctionFactory, 10000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false));
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)valuesOperatorFactory.createOperator(driverContext), (Operator[])new Operator[]{buildOperatorFactory.createOperator(driverContext)});
        PagesSpatialIndexFactory pagesSpatialIndexFactory = buildOperatorFactory.getPagesSpatialIndexFactory();
        ListenableFuture pagesSpatialIndex = pagesSpatialIndexFactory.createPagesSpatialIndex();
        while (!pagesSpatialIndex.isDone()) {
            driver.processUntilBlocked();
        }
        TestSpatialJoinOperator.runDriverInThread(this.executor, driver);
        return pagesSpatialIndexFactory;
    }

    private static void runDriverInThread(ExecutorService executor, Driver driver) {
        executor.execute(() -> {
            if (!driver.isFinished()) {
                try {
                    driver.processUntilBlocked();
                }
                catch (TrinoException e) {
                    driver.getDriverContext().failed((Throwable)e);
                    throw e;
                }
                TestSpatialJoinOperator.runDriverInThread(executor, driver);
            }
        });
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }

    private static class TestInternalJoinFilterFunction
    implements InternalJoinFilterFunction {
        private final Lambda lambda;

        private TestInternalJoinFilterFunction(Lambda lambda) {
            this.lambda = lambda;
        }

        public boolean filter(int leftPosition, Page leftPage, int rightPosition, Page rightPage) {
            return this.lambda.filter(leftPosition, leftPage, rightPosition, rightPage);
        }

        public static interface Lambda {
            public boolean filter(int var1, Page var2, int var3, Page var4);
        }
    }
}

