/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.trino.Session;
import io.trino.block.BlockSerdeUtil;
import io.trino.execution.warnings.WarningCollector;
import io.trino.geospatial.KdbTree;
import io.trino.geospatial.KdbTreeUtils;
import io.trino.geospatial.Rectangle;
import io.trino.plugin.geospatial.GeoFunctions;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.geospatial.KdbTreeType;
import io.trino.plugin.memory.MemoryConnectorFactory;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSpatialJoinPlanning
extends BasePlanTest {
    private static final String KDB_TREE_JSON = KdbTreeUtils.toJson((KdbTree)new KdbTree(KdbTree.Node.newLeaf((Rectangle)new Rectangle(0.0, 0.0, 10.0, 10.0), (int)0)));
    private String kdbTreeLiteral;
    private String point21x21Literal;

    protected LocalQueryRunner createLocalQueryRunner() {
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().setCatalog("memory").setSchema("default").build());
        queryRunner.installPlugin((Plugin)new GeoPlugin());
        queryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        queryRunner.createCatalog("memory", (ConnectorFactory)new MemoryConnectorFactory(), (Map)ImmutableMap.of());
        queryRunner.execute(String.format("CREATE TABLE kdb_tree AS SELECT '%s' AS v", KDB_TREE_JSON));
        queryRunner.execute("CREATE TABLE points (lng, lat, name) AS (VALUES (2.1e0, 2.1e0, 'x'))");
        queryRunner.execute("CREATE TABLE polygons (wkt, name) AS (VALUES ('POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))', 'a'))");
        return queryRunner;
    }

    @BeforeClass
    public void setUp() {
        Block block = Utils.nativeValueToBlock((Type)KdbTreeType.KDB_TREE, (Object)KdbTreeUtils.fromJson((String)KDB_TREE_JSON));
        DynamicSliceOutput output = new DynamicSliceOutput(0);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)new TestingBlockEncodingSerde(), (SliceOutput)output, (Block)block);
        this.kdbTreeLiteral = String.format("\"%s\"(from_base64('%s'))", "$literal$", Base64.getEncoder().encodeToString(output.slice().getBytes()));
        this.point21x21Literal = String.format("\"%s\"(from_base64('%s'))", "$literal$", Base64.getEncoder().encodeToString(GeoFunctions.stPoint((double)2.1, (double)2.1).getBytes()));
    }

    @Test
    public void testSpatialJoinContains() {
        this.assertPlan("SELECT b.name, a.name FROM points a, polygons b WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name_a", (Object)"name"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_b", (Object)"name")))}))}));
        this.assertPlan("SELECT * FROM (SELECT length(name), * FROM points), (SELECT length(name), * FROM polygons) WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)"), (Object)"length", (Object)PlanMatchPattern.expression((String)"length(name)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name", (Object)"name"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))"), (Object)"length_2", (Object)PlanMatchPattern.expression((String)"length(name_2)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_2", (Object)"name")))}))}));
        this.assertDistributedPlan("SELECT b.name, a.name FROM points a, polygons b WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", this.withSpatialPartitioning("kdb_tree"), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_contains(st_geometryfromtext, st_point)", Optional.of(KDB_TREE_JSON), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"partitions", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, st_point)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name", (Object)"name")))))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"partitions", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, st_geometryfromtext)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_2", (Object)"name")))))}))}));
    }

    @Test
    public void testSpatialJoinWithin() {
        this.assertPlan("SELECT points.name, polygons.name FROM points, polygons WHERE ST_Within(ST_GeometryFromText(wkt), ST_Point(lng, lat))", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_within(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name_a", (Object)"name"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_b", (Object)"name")))}))}));
        this.assertPlan("SELECT * FROM (SELECT length(name), * FROM points), (SELECT length(name), * FROM polygons) WHERE ST_Within(ST_GeometryFromText(wkt), ST_Point(lng, lat))", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_within(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)"), (Object)"length", (Object)PlanMatchPattern.expression((String)"length(name)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name", (Object)"name"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))"), (Object)"length_2", (Object)PlanMatchPattern.expression((String)"length(name_2)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_2", (Object)"name")))}))}));
        this.assertDistributedPlan("SELECT b.name, a.name FROM points a, polygons b WHERE ST_Within(ST_GeometryFromText(wkt), ST_Point(lng, lat))", this.withSpatialPartitioning("kdb_tree"), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_within(st_geometryfromtext, st_point)", Optional.of(KDB_TREE_JSON), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"partitions", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, st_point)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name_a", (Object)"name")))))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"partitions", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, st_geometryfromtext)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_b", (Object)"name")))))}))}));
    }

    @Test
    public void testInvalidKdbTree() {
        this.assertInvalidSpatialPartitioning(this.withSpatialPartitioning("non_existent_table"), "SELECT b.name, a.name FROM points a, polygons b WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", "Table not found: memory.default.non_existent_table");
        this.getQueryRunner().execute("CREATE TABLE empty_table AS SELECT 'a' AS v WHERE false");
        this.assertInvalidSpatialPartitioning(this.withSpatialPartitioning("empty_table"), "SELECT b.name, a.name FROM points a, polygons b WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", "Expected exactly one row for table memory.default.empty_table, but got none");
        this.getQueryRunner().execute("CREATE TABLE invalid_kdb_tree AS SELECT 'invalid-json' AS v");
        this.assertInvalidSpatialPartitioning(this.withSpatialPartitioning("invalid_kdb_tree"), "SELECT b.name, a.name FROM points a, polygons b WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", "Invalid JSON string for KDB tree: .*");
        this.getQueryRunner().execute(String.format("CREATE TABLE too_many_rows AS SELECT * FROM (VALUES '%s', '%s') AS t(v)", KDB_TREE_JSON, KDB_TREE_JSON));
        this.assertInvalidSpatialPartitioning(this.withSpatialPartitioning("too_many_rows"), "SELECT b.name, a.name FROM points a, polygons b WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", "Expected exactly one row for table memory.default.too_many_rows, but found 2 rows");
        this.getQueryRunner().execute("CREATE TABLE too_many_columns AS SELECT '%s' as c1, 100 as c2");
        this.assertInvalidSpatialPartitioning(this.withSpatialPartitioning("too_many_columns"), "SELECT b.name, a.name FROM points a, polygons b WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", "Expected single column for table memory.default.too_many_columns, but found 2 columns");
    }

    private void assertInvalidSpatialPartitioning(Session session, String sql, String expectedMessageRegExp) {
        block2: {
            LocalQueryRunner queryRunner = this.getQueryRunner();
            try {
                queryRunner.inTransaction(session, transactionSession -> {
                    queryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, WarningCollector.NOOP);
                    return null;
                });
                Assert.fail((String)String.format("Expected query to fail: %s", sql));
            }
            catch (TrinoException ex) {
                Assert.assertEquals((Object)ex.getErrorCode(), (Object)StandardErrorCode.INVALID_SPATIAL_PARTITIONING.toErrorCode());
                if (Strings.nullToEmpty((String)ex.getMessage()).matches(expectedMessageRegExp)) break block2;
                Assert.fail((String)String.format("Expected exception message '%s' to match '%s' for query: %s", ex.getMessage(), expectedMessageRegExp, sql), (Throwable)ex);
            }
        }
    }

    @Test
    public void testSpatialJoinIntersects() {
        this.assertPlan("SELECT b.name, a.name FROM polygons a, polygons b WHERE ST_Intersects(ST_GeometryFromText(a.wkt), ST_GeometryFromText(b.wkt))", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_intersects(geometry_a, geometry_b)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"geometry_a", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt_a as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt_a", (Object)"wkt", (Object)"name_a", (Object)"name"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"geometry_b", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt_b as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt_b", (Object)"wkt", (Object)"name_b", (Object)"name")))}))}));
        this.assertDistributedPlan("SELECT b.name, a.name FROM polygons a, polygons b WHERE ST_Intersects(ST_GeometryFromText(a.wkt), ST_GeometryFromText(b.wkt))", this.withSpatialPartitioning("default.kdb_tree"), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_intersects(geometry_a, geometry_b)", Optional.of(KDB_TREE_JSON), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"partitions", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, geometry_a)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"geometry_a", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt_a as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt_a", (Object)"wkt", (Object)"name_a", (Object)"name")))))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"partitions", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, geometry_b)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"geometry_b", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt_b as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt_b", (Object)"wkt", (Object)"name_b", (Object)"name"))))}))}));
    }

    @Test
    public void testDistanceQuery() {
        this.assertPlan("SELECT b.name, a.name FROM " + this.singleRow("2.1", "2.1", "'x'") + " AS a (lng, lat, name), " + this.singleRow("2.1", "2.1", "'x'") + " AS b (lng, lat, name) WHERE ST_Distance(ST_Point(a.lng, a.lat), ST_Point(b.lng, b.lat)) <= 3.1", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_distance(st_point_a, st_point_b) <= radius", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point_a", (Object)PlanMatchPattern.expression((String)this.point21x21Literal), (Object)"a_name", (Object)PlanMatchPattern.expression((String)"'x'")), (PlanMatchPattern)this.singleRow()), (PlanMatchPattern)PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point_b", (Object)PlanMatchPattern.expression((String)this.point21x21Literal), (Object)"radius", (Object)PlanMatchPattern.expression((String)"3.1e0"), (Object)"b_name", (Object)PlanMatchPattern.expression((String)"'x'")), (PlanMatchPattern)this.singleRow())}))}));
        this.assertPlan("SELECT b.name, a.name FROM " + this.singleRow("2.1", "2.1", "'x'") + " AS a (lng, lat, name), " + this.singleRow("2.1", "2.1", "'x'") + " AS b (lng, lat, name) WHERE ST_Distance(ST_Point(a.lng, a.lat), ST_Point(b.lng, b.lat)) <= 300 / (cos(radians(b.lat)) * 111321)", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_distance(st_point_a, st_point_b) <= radius", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point_a", (Object)PlanMatchPattern.expression((String)this.point21x21Literal), (Object)"a_name", (Object)PlanMatchPattern.expression((String)"'x'")), (PlanMatchPattern)this.singleRow()), (PlanMatchPattern)PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point_b", (Object)PlanMatchPattern.expression((String)this.point21x21Literal), (Object)"radius", (Object)PlanMatchPattern.expression((String)TestSpatialJoinPlanning.doubleLiteral(300.0 / (Math.cos(Math.toRadians(2.1)) * 111321.0))), (Object)"b_name", (Object)PlanMatchPattern.expression((String)"'x'")), (PlanMatchPattern)this.singleRow())}))}));
        this.assertDistributedPlan("SELECT b.name, a.name FROM " + this.singleRow("2.1", "2.1", "'x'") + " AS a (lng, lat, name), " + this.singleRow("2.1", "2.1", "'x'") + " AS b (lng, lat, name) WHERE ST_Distance(ST_Point(a.lng, a.lat), ST_Point(b.lng, b.lat)) <= 3.1", this.withSpatialPartitioning("memory.default.kdb_tree"), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_distance(st_point_a, st_point_b) <= radius", Optional.of(KDB_TREE_JSON), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point_a", (Object)PlanMatchPattern.expression((String)this.point21x21Literal), (Object)"partitions", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, %s)", this.kdbTreeLiteral, this.point21x21Literal))), (PlanMatchPattern)this.singleRow()))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point_b", (Object)PlanMatchPattern.expression((String)this.point21x21Literal), (Object)"partitions", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, %s, 3.1e0)", this.kdbTreeLiteral, this.point21x21Literal)), (Object)"radius", (Object)PlanMatchPattern.expression((String)"3.1e0")), (PlanMatchPattern)this.singleRow()))}))}));
    }

    @Test
    public void testNotContains() {
        this.assertPlan("SELECT b.name, a.name FROM points a, polygons b WHERE NOT ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"NOT ST_Contains(ST_GeometryFromText(cast(wkt as varchar)), ST_Point(lng, lat))", (PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, Collections.emptyList(), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name_a", (Object)"name")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_b", (Object)"name"))})))}));
    }

    @Test
    public void testNotIntersects() {
        this.assertPlan(String.format("SELECT b.name, a.name FROM " + this.singleRow("IF(rand() >= 0, 'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))')", "'a'") + " AS a (wkt, name), " + this.singleRow("IF(rand() >= 0, 'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))')", "'a'") + " AS b (wkt, name)            WHERE NOT ST_Intersects(ST_GeometryFromText(a.wkt), ST_GeometryFromText(b.wkt))", this.singleRow()), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"NOT ST_Intersects(ST_GeometryFromText(cast(wkt_a as varchar)), ST_GeometryFromText(cast(wkt_b as varchar)))", (PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, Collections.emptyList(), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"wkt_a", (Object)PlanMatchPattern.expression((String)"(CASE WHEN (rand() >= 0E0) THEN 'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))' END)"), (Object)"name_a", (Object)PlanMatchPattern.expression((String)"'a'")), (PlanMatchPattern)this.singleRow()), (PlanMatchPattern)PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"wkt_b", (Object)PlanMatchPattern.expression((String)"(CASE WHEN (rand() >= 0E0) THEN 'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))' END)"), (Object)"name_b", (Object)PlanMatchPattern.expression((String)"'a'")), (PlanMatchPattern)this.singleRow())})))}));
    }

    @Test
    public void testContainsWithEquiClause() {
        this.assertPlan("SELECT b.name, a.name FROM points a, polygons b WHERE a.name = b.name AND ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"name_a", (String)"name_b")), Optional.of("ST_Contains(ST_GeometryFromText(cast(wkt as varchar)), ST_Point(lng, lat))"), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name_a", (Object)"name"))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_b", (Object)"name"))}))}));
    }

    @Test
    public void testIntersectsWithEquiClause() {
        this.assertPlan("SELECT b.name, a.name FROM polygons a, polygons b WHERE a.name = b.name AND ST_Intersects(ST_GeometryFromText(a.wkt), ST_GeometryFromText(b.wkt))", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"name_a", (String)"name_b")), Optional.of("ST_Intersects(ST_GeometryFromText(cast(wkt_a as varchar)), ST_GeometryFromText(cast(wkt_b as varchar)))"), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt_a", (Object)"wkt", (Object)"name_a", (Object)"name"))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt_b", (Object)"wkt", (Object)"name_b", (Object)"name"))}))}));
    }

    @Test
    public void testSpatialLeftJoins() {
        this.assertPlan("SELECT b.name, a.name FROM points a LEFT JOIN polygons b ON ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialLeftJoin((String)"st_contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name_a", (Object)"name"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_b", (Object)"name")))}))}));
        this.assertPlan("SELECT b.name, a.name FROM points a LEFT JOIN polygons b ON ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat)) AND a.name <> b.name", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialLeftJoin((String)"st_contains(st_geometryfromtext, st_point) AND name_a <> name_b", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name_a", (Object)"name"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_b", (Object)"name")))}))}));
        this.assertPlan("SELECT b.name, a.name FROM points a LEFT JOIN polygons b ON ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat)) AND rand() < 0.5", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialLeftJoin((String)"st_contains(st_geometryfromtext, st_point) AND rand() < 5e-1", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name_a", (Object)"name"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_b", (Object)"name")))}))}));
        this.assertPlan("SELECT b.name, a.name FROM points a LEFT JOIN polygons b    ON ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat)) WHERE concat(a.name, b.name) is null", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"concat(cast(name_a as varchar), cast(name_b as varchar)) is null", (PlanMatchPattern)PlanMatchPattern.spatialLeftJoin((String)"st_contains(st_geometryfromtext, st_point)", (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression((String)"ST_Point(lng, lat)")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"points", (Map)ImmutableMap.of((Object)"lng", (Object)"lng", (Object)"lat", (Object)"lat", (Object)"name_a", (Object)"name"))), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(wkt as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"polygons", (Map)ImmutableMap.of((Object)"wkt", (Object)"wkt", (Object)"name_b", (Object)"name")))})))}));
    }

    @Test
    public void testDistributedSpatialJoinOverUnion() {
        this.assertDistributedPlan("SELECT a.name, b.name FROM (SELECT name FROM tpch.tiny.region UNION ALL SELECT name FROM tpch.tiny.nation) a, tpch.tiny.customer b WHERE ST_Contains(ST_GeometryFromText(a.name), ST_GeometryFromText(b.name))", this.withSpatialPartitioning("kdb_tree"), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_contains(g1, g3)", Optional.of(KDB_TREE_JSON), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"p1", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, g1)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"g1", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(name_a1 as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"region", (Map)ImmutableMap.of((Object)"name_a1", (Object)"name")))), PlanMatchPattern.project((Map)ImmutableMap.of((Object)"p2", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, g2)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"g2", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(name_a2 as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"nation", (Map)ImmutableMap.of((Object)"name_a2", (Object)"name"))))}))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"p3", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, g3)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"g3", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(name_b as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"customer", (Map)ImmutableMap.of((Object)"name_b", (Object)"name")))))}))}));
        this.assertDistributedPlan("SELECT a.name, b.name FROM tpch.tiny.customer a, (SELECT name FROM tpch.tiny.region UNION ALL SELECT name FROM tpch.tiny.nation) b WHERE ST_Contains(ST_GeometryFromText(a.name), ST_GeometryFromText(b.name))", this.withSpatialPartitioning("kdb_tree"), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.spatialJoin((String)"st_contains(g1, g2)", Optional.of(KDB_TREE_JSON), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"p1", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, g1)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"g1", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(name_a as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"customer", (Map)ImmutableMap.of((Object)"name_a", (Object)"name")))))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.unnest((PlanMatchPattern)PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"p2", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, g2)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"g2", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(name_b1 as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"region", (Map)ImmutableMap.of((Object)"name_b1", (Object)"name")))), PlanMatchPattern.project((Map)ImmutableMap.of((Object)"p3", (Object)PlanMatchPattern.expression((String)String.format("spatial_partitions(%s, g3)", this.kdbTreeLiteral))), (PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"g3", (Object)PlanMatchPattern.expression((String)"ST_GeometryFromText(cast(name_b2 as varchar))")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"nation", (Map)ImmutableMap.of((Object)"name_b2", (Object)"name"))))}))}))}));
    }

    private String singleRow(String ... columns) {
        String outputs = String.join((CharSequence)", ", columns);
        return String.format("(SELECT %s FROM tpch.tiny.region WHERE regionkey = 1)", outputs);
    }

    private PlanMatchPattern singleRow() {
        return PlanMatchPattern.filter((String)"regionkey = BIGINT '1'", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"region", (Map)ImmutableMap.of((Object)"regionkey", (Object)"regionkey")));
    }

    private Session withSpatialPartitioning(String tableName) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("spatial_partitioning_table_name", tableName).build();
    }

    private static String doubleLiteral(double value) {
        Preconditions.checkArgument((boolean)Double.isFinite(value));
        return String.format("%.16E", value);
    }
}

