/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.trino.Session;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.spi.Plugin;
import io.trino.spi.security.PrincipalType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.TestingSession;
import java.io.File;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSpatialJoins
extends AbstractTestQueryFramework {
    private static final String POLYGONS_SQL = "VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)";
    private static final String POINTS_SQL = "VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)";
    private static final String MULTI_POINTS_SQL = "VALUES (-0.1, -0.1, 5.1, 5.1, 'x', 1), (7.1, 7.1, 2.1, 2.1, 'y', 2), (7.1, 7.2, 8, 9, 'z', 3), (null, 1.2, 4, null, 'null', 4)";

    protected DistributedQueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setSource(TestSpatialJoins.class.getSimpleName()).setCatalog("hive").setSchema("default").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).build();
        queryRunner.installPlugin((Plugin)new GeoPlugin());
        File baseDir = queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data").toFile();
        FileHiveMetastore metastore = FileHiveMetastore.createTestingFileHiveMetastore((File)baseDir);
        metastore.createDatabase(Database.builder().setDatabaseName("default").setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build());
        queryRunner.installPlugin((Plugin)new TestingHivePlugin((HiveMetastore)metastore));
        queryRunner.createCatalog("hive", "hive");
        return queryRunner;
    }

    @Test
    public void testBroadcastSpatialJoinContains() {
        this.testSpatialJoinContains(this.getSession());
    }

    @Test
    public void testDistributedSpatialJoinContains() {
        this.assertUpdate(String.format("CREATE TABLE contains_partitioning AS SELECT spatial_partitioning(ST_GeometryFromText(wkt)) as v FROM (%s) as a (wkt, name, id)", POLYGONS_SQL), 1L);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("spatial_partitioning_table_name", "contains_partitioning").build();
        this.testSpatialJoinContains(session);
    }

    private void testSpatialJoinContains(Session session) {
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)) AS a (latitude, longitude, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(longitude, latitude))", "VALUES ('a', 'x'), ('b', 'y'), ('c', 'y'), ('d', 'z')");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)) AS a (latitude, longitude, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(wkt), ST_Point(longitude, latitude))", "VALUES ('a', 'x'), ('b', 'y'), ('c', 'y'), ('d', 'z')");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('c', 'b')");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('c', 'b')");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id), (VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)) AS a (latitude, longitude, name, id) WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(longitude, latitude))", "VALUES ('a', 'x'), ('b', 'y'), ('c', 'y'), ('d', 'z')");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(a.wkt), ST_GeometryFromText(b.wkt))", "VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('b', 'c')");
    }

    @Test
    public void testBroadcastSpatialJoinContainsWithExtraConditions() {
        this.assertQuery("SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt)) AND a.name != b.name", "VALUES ('c', 'b')");
        this.assertQuery("SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt)) AND a.name != b.name", "VALUES ('c', 'b')");
    }

    @Test
    public void testBroadcastSpatialJoinContainsWithStatefulExtraCondition() {
        String pointsX = TestSpatialJoins.generatePointsSql(0.0, 0.0, 1.0, 1.0, 10000, "x");
        String pointsY = TestSpatialJoins.generatePointsSql(2.0, 2.0, 2.5, 2.5, 10000, "y");
        this.assertQuery("SELECT b.name, a.name FROM (" + pointsX + " UNION ALL " + pointsY + ") AS a (latitude, longitude, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(longitude, latitude)) AND stateful_sleeping_sum(0.001, 100, a.id, b.id) <= 3", "VALUES ('a', 'x1'), ('a', 'x2'), ('b', 'y1')");
    }

    private static String generatePointsSql(double minX, double minY, double maxX, double maxY, int pointCount, String prefix) {
        return String.format("SELECT %s + n * %f, %s + n * %f, '%s' || CAST (n AS VARCHAR), n FROM (SELECT sequence(1, %s) as numbers) CROSS JOIN UNNEST (numbers) AS t(n)", minX, (maxX - minX) / (double)pointCount, minY, (maxY - minY) / (double)pointCount, prefix, pointCount);
    }

    @Test
    public void testBroadcastSpatialJoinContainsWithEmptyBuildSide() {
        this.assertQueryReturnsEmptyResult("SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE b.name = 'invalid' AND ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))");
    }

    @Test
    public void testBroadcastSpatialJoinContainsWithEmptyProbeSide() {
        this.assertQueryReturnsEmptyResult("SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE a.name = 'invalid' AND ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))");
    }

    @Test
    public void testBroadcastSpatialJoinIntersects() {
        this.testSpatialJoinIntersects(this.getSession());
    }

    @Test
    public void tesDistributedSpatialJoinIntersects() {
        this.assertUpdate(String.format("CREATE TABLE intersects_partitioning AS SELECT spatial_partitioning(ST_GeometryFromText(wkt)) as v FROM (%s) as a (wkt, name, id)", POLYGONS_SQL), 1L);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("spatial_partitioning_table_name", "intersects_partitioning").build();
        this.testSpatialJoinIntersects(session);
    }

    private void testSpatialJoinIntersects(Session session) {
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Intersects(ST_GeometryFromText(a.wkt), ST_GeometryFromText(b.wkt))", "SELECT * FROM VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
    }

    @Test
    public void testBroadcastSpatialJoinIntersectsWithExtraConditions() {
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))    AND a.name != b.name", "VALUES ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))    AND a.name != b.name", "VALUES ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))    AND a.name < b.name", "VALUES ('a', 'c'), ('b', 'c')");
    }

    @Test
    public void testBroadcastDistanceQuery() {
        this.testDistanceQuery(this.getSession());
    }

    @Test
    public void testDistributedDistanceQuery() {
        this.assertUpdate("CREATE TABLE distance_partitioning AS SELECT spatial_partitioning(ST_Point(x, y)) as v FROM (VALUES (0, 0, '0_0'), (1, 0, '1_0'), (3, 0, '3_0'), (10, 0, '10_0')) as a (x, y, name)", 1L);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("spatial_partitioning_table_name", "distance_partitioning").build();
        this.testDistanceQuery(session);
    }

    private void testDistanceQuery(Session session) {
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES (0, 0, '0_0'), (1, 0, '1_0'), (3, 0, '3_0'), (10, 0, '10_0')) as a (x, y, name), (VALUES (0, 1, '0_1'), (1, 1, '1_1'), (3, 1, '3_1'), (10, 1, '10_1')) as b (x, y, name) WHERE ST_Distance(ST_Point(a.x, a.y), ST_Point(b.x, b.y)) <= 1.5", "VALUES ('0_0', '0_1'), ('0_0', '1_1'), ('1_0', '0_1'), ('1_0', '1_1'), ('3_0', '3_1'), ('10_0', '10_1')");
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES (0, 0, '0_0'), (1, 0, '1_0'), (3, 0, '3_0'), (10, 0, '10_0')) as a (x, y, name), (VALUES (0, 1, '0_1'), (1, 1, '1_1'), (3, 1, '3_1'), (10, 1, '10_1')) as b (x, y, name) WHERE ST_Distance(ST_Point(b.x, b.y), ST_Point(a.x, a.y)) <= 1.5", "VALUES ('0_0', '0_1'), ('0_0', '1_1'), ('1_0', '0_1'), ('1_0', '1_1'), ('3_0', '3_1'), ('10_0', '10_1')");
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES (0, 0, '0_0'), (1, 0, '1_0'), (3, 0, '3_0'), (10, 0, '10_0')) as a (x, y, name), (VALUES (0, 1, '0_1'), (1, 1, '1_1'), (3, 1, '3_1'), (10, 1, '10_1')) as b (x, y, name) WHERE ST_Distance(ST_Point(a.x, a.y), ST_Point(b.x, b.y)) <= sqrt(b.x * b.x + b.y * b.y)", "VALUES ('0_0', '0_1'), ('0_0', '1_1'), ('0_0', '3_1'), ('0_0', '10_1'), ('1_0', '1_1'), ('1_0', '3_1'), ('1_0', '10_1'), ('3_0', '3_1'), ('3_0', '10_1'), ('10_0', '10_1')");
    }

    @Test
    public void testBroadcastSpatialLeftJoin() {
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) LEFT JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c'), ('empty', null), ('null', null)");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) LEFT JOIN (VALUES (null, 'null', 1)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "VALUES ('a', null), ('b', null), ('c', null), ('d', null), ('empty', null), ('null', null)");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) LEFT JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON a.name > b.name AND ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "VALUES ('a', null), ('b', null), ('c', 'a'), ('c', 'b'), ('d', null), ('empty', null), ('null', null)");
    }

    @Test
    public void testBroadcastSpatialRightJoin() {
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) RIGHT JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c'), (null, 'empty'), (null, 'null')");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) RIGHT JOIN (VALUES (null, 'null', 1)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "VALUES (null, 'null')");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) RIGHT JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON a.name > b.name AND ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "VALUES (null, 'c'), (null, 'd'), ('c', 'a'), ('c', 'b'), (null, 'empty'), (null, 'null')");
    }

    @Test
    public void testSpatialJoinOverRightJoin() {
        this.assertQuery("SELECT a.name, b.name, c.name FROM (VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)) AS a (latitude, longitude, name, id) RIGHT JOIN (VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)) AS b (latitude, longitude, name, id) ON a.latitude = b.latitude AND a.longitude = b.longitude AND a.latitude > 0 JOIN (VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)) AS c (latitude, longitude, name, id) ON ST_Distance(ST_Point(a.latitude, b.longitude), ST_Point(c.latitude, c.longitude)) < 1 ", "VALUES ('y', 'y', 'y'), ('z', 'z', 'z')");
    }

    @Test
    public void testSpatialJoinOverLeftJoinWithOrPredicate() {
        this.assertQuery("SELECT a.name, b.name FROM (VALUES (-0.1, -0.1, 5.1, 5.1, 'x', 1), (7.1, 7.1, 2.1, 2.1, 'y', 2), (7.1, 7.2, 8, 9, 'z', 3), (null, 1.2, 4, null, 'null', 4)) AS a (latitude1, longitude1, latitude2, longitude2, name, id) LEFT JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(b.wkt), ST_Point(a.latitude1, a.longitude1)) OR ST_Contains(ST_GeometryFromText(b.wkt), ST_Point(a.latitude2, a.longitude2))", "VALUES ('x', 'a'), ('y', 'b') , ('y', 'c'), ('z', NULL), ('null', NULL)");
    }

    @Test
    public void testSpatialJoinOverRightJoinWithOrPredicate() {
        this.assertQuery("SELECT a.name, b.name FROM (VALUES (-0.1, -0.1, 5.1, 5.1, 'x', 1), (7.1, 7.1, 2.1, 2.1, 'y', 2), (7.1, 7.2, 8, 9, 'z', 3), (null, 1.2, 4, null, 'null', 4)) AS a (latitude1, longitude1, latitude2, longitude2, name, id) RIGHT JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(b.wkt), ST_Point(a.latitude1, a.longitude1)) OR ST_Contains(ST_GeometryFromText(b.wkt), ST_Point(a.latitude2, a.longitude2))", "VALUES ('x', 'a'), ('y', 'b') , ('y', 'c'), (NULL, 'd'), (NULL, 'empty'), (NULL, 'null')");
    }

    @Test
    public void testSpatialJoinOverInnerJoinWithOrPredicate() {
        this.assertQuery("SELECT a.name, b.name FROM (VALUES (-0.1, -0.1, 5.1, 5.1, 'x', 1), (7.1, 7.1, 2.1, 2.1, 'y', 2), (7.1, 7.2, 8, 9, 'z', 3), (null, 1.2, 4, null, 'null', 4)) AS a (latitude1, longitude1, latitude2, longitude2, name, id) INNER JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(b.wkt), ST_Point(a.latitude1, a.longitude1)) OR ST_Contains(ST_GeometryFromText(b.wkt), ST_Point(a.latitude2, a.longitude2))", "VALUES ('x', 'a'), ('y', 'b') , ('y', 'c')");
    }

    @Test
    public void testSpatialJoinOverFullJoinWithOrPredicate() {
        this.assertQuery("SELECT a.name, b.name FROM (VALUES (-0.1, -0.1, 5.1, 5.1, 'x', 1), (7.1, 7.1, 2.1, 2.1, 'y', 2), (7.1, 7.2, 8, 9, 'z', 3), (null, 1.2, 4, null, 'null', 4)) AS a (latitude1, longitude1, latitude2, longitude2, name, id) FULL JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(b.wkt), ST_Point(a.latitude1, a.longitude1)) OR ST_Contains(ST_GeometryFromText(b.wkt), ST_Point(a.latitude2, a.longitude2))", "VALUES ('x', 'a'), ('y', 'b'), ('y', 'c'), (NULL, 'd'), (NULL, 'empty'), ('z', NULL), (NULL, 'null'), ('null', NULL)");
    }
}

