/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import com.google.common.collect.ImmutableList;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Ints;
import io.trino.block.BlockAssertions;
import io.trino.geospatial.KdbTree;
import io.trino.geospatial.KdbTreeUtils;
import io.trino.geospatial.Rectangle;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.Aggregator;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.operator.aggregation.GroupedAggregator;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.spi.Page;
import io.trino.spi.Plugin;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.tree.QualifiedName;
import java.math.RoundingMode;
import java.util.List;
import java.util.OptionalInt;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestSpatialPartitioningInternalAggregation
extends AbstractTestFunctions {
    @BeforeClass
    public void setup() {
        this.functionAssertions.installPlugin((Plugin)new GeoPlugin());
    }

    @DataProvider(name="partitionCount")
    public static Object[][] partitionCountProvider() {
        return new Object[][]{{100}, {10}};
    }

    @Test(dataProvider="partitionCount")
    public void test(int partitionCount) {
        TestingAggregationFunction function = this.getFunction();
        List<OGCGeometry> geometries = this.makeGeometries();
        Block geometryBlock = this.makeGeometryBlock(geometries);
        Block partitionCountBlock = BlockAssertions.createRepeatedValuesBlock((long)partitionCount, (int)geometries.size());
        Rectangle expectedExtent = new Rectangle(-10.0, -10.0, Math.nextUp(10.0), Math.nextUp(10.0));
        String expectedValue = this.getSpatialPartitioning(expectedExtent, geometries, partitionCount);
        AggregatorFactory aggregatorFactory = function.createAggregatorFactory(AggregationNode.Step.SINGLE, Ints.asList((int[])new int[]{0, 1}), OptionalInt.empty());
        Page page = new Page(new Block[]{geometryBlock, partitionCountBlock});
        Aggregator aggregator = aggregatorFactory.createAggregator();
        aggregator.processPage(page);
        String aggregation = (String)BlockAssertions.getOnlyValue((Type)function.getFinalType(), (Block)AggregationTestUtils.getFinalBlock((Type)function.getFinalType(), (Aggregator)aggregator));
        Assert.assertEquals((String)aggregation, (String)expectedValue);
        GroupedAggregator groupedAggregator = aggregatorFactory.createGroupedAggregator();
        groupedAggregator.processPage(AggregationTestUtils.createGroupByIdBlock((int)0, (int)page.getPositionCount()), page);
        String groupValue = (String)AggregationTestUtils.getGroupValue((Type)function.getFinalType(), (GroupedAggregator)groupedAggregator, (int)0);
        Assert.assertEquals((String)groupValue, (String)expectedValue);
    }

    private TestingAggregationFunction getFunction() {
        return this.functionAssertions.getFunctionResolution().getAggregateFunction(QualifiedName.of((String)"spatial_partitioning"), TypeSignatureProvider.fromTypes((Type[])new Type[]{GeometryType.GEOMETRY, IntegerType.INTEGER}));
    }

    private List<OGCGeometry> makeGeometries() {
        int j;
        int i;
        ImmutableList.Builder geometries = ImmutableList.builder();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                geometries.add((Object)new OGCPoint(new Point((double)(-10 + i), (double)(-10 + j)), null));
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                geometries.add((Object)new OGCPoint(new Point((double)(-10 + 2 * i), (double)(2 * j)), null));
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                geometries.add((Object)new OGCPoint(new Point(2.5 * (double)i, -10.0 + 2.5 * (double)j), null));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                geometries.add((Object)new OGCPoint(new Point((double)(5 * i), (double)(5 * j)), null));
            }
        }
        return geometries.build();
    }

    private Block makeGeometryBlock(List<OGCGeometry> geometries) {
        BlockBuilder builder = GeometryType.GEOMETRY.createBlockBuilder(null, geometries.size());
        for (OGCGeometry geometry : geometries) {
            GeometryType.GEOMETRY.writeSlice(builder, GeometrySerde.serialize((OGCGeometry)geometry));
        }
        return builder.build();
    }

    private String getSpatialPartitioning(Rectangle extent, List<OGCGeometry> geometries, int partitionCount) {
        ImmutableList.Builder rectangles = ImmutableList.builder();
        for (OGCGeometry geometry : geometries) {
            Envelope envelope = new Envelope();
            geometry.getEsriGeometry().queryEnvelope(envelope);
            rectangles.add((Object)new Rectangle(envelope.getXMin(), envelope.getYMin(), envelope.getXMax(), envelope.getYMax()));
        }
        return KdbTreeUtils.toJson((KdbTree)KdbTree.buildKdbTree((int)DoubleMath.roundToInt((double)((double)geometries.size() * 1.0 / (double)partitionCount), (RoundingMode)RoundingMode.CEILING), (Rectangle)extent, (List)rectangles.build()));
    }
}

