/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.plugin.geospatial.GeoFunctions;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.geospatial.SphericalGeographyType;
import io.trino.spi.Plugin;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSphericalGeoFunctions
extends AbstractTestFunctions {
    @BeforeClass
    public void registerFunctions() {
        this.functionAssertions.installPlugin((Plugin)new GeoPlugin());
    }

    @Test
    public void testGetObjectValue() {
        ImmutableList wktList = ImmutableList.of((Object)"POINT EMPTY", (Object)"MULTIPOINT EMPTY", (Object)"LINESTRING EMPTY", (Object)"MULTILINESTRING EMPTY", (Object)"POLYGON EMPTY", (Object)"MULTIPOLYGON EMPTY", (Object)"GEOMETRYCOLLECTION EMPTY", (Object)"POINT (-40.2 28.9)", (Object)"MULTIPOINT ((-40.2 28.9), (-40.2 31.9))", (Object)"LINESTRING (-40.2 28.9, -40.2 31.9, -37.2 31.9)", (Object)"MULTILINESTRING ((-40.2 28.9, -40.2 31.9), (-40.2 31.9, -37.2 31.9))", (Object)"POLYGON ((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9))", (Object[])new String[]{"POLYGON ((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9), (-39.2 29.9, -39.2 30.9, -38.2 30.9, -38.2 29.9, -39.2 29.9))", "MULTIPOLYGON (((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9)), ((-39.2 29.9, -38.2 29.9, -38.2 30.9, -39.2 30.9, -39.2 29.9)))", "GEOMETRYCOLLECTION (POINT (-40.2 28.9), LINESTRING (-40.2 28.9, -40.2 31.9, -37.2 31.9), POLYGON ((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9)))"});
        BlockBuilder builder = SphericalGeographyType.SPHERICAL_GEOGRAPHY.createBlockBuilder(null, wktList.size());
        for (String wkt : wktList) {
            SphericalGeographyType.SPHERICAL_GEOGRAPHY.writeSlice(builder, GeoFunctions.toSphericalGeography((Slice)GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)wkt))));
        }
        Block block = builder.build();
        for (int i = 0; i < wktList.size(); ++i) {
            Assert.assertEquals(wktList.get(i), (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY.getObjectValue(null, block, i));
        }
    }

    @Test
    public void testToAndFromSphericalGeography() {
        this.assertToAndFromSphericalGeography("POINT EMPTY");
        this.assertToAndFromSphericalGeography("MULTIPOINT EMPTY");
        this.assertToAndFromSphericalGeography("LINESTRING EMPTY");
        this.assertToAndFromSphericalGeography("MULTILINESTRING EMPTY");
        this.assertToAndFromSphericalGeography("POLYGON EMPTY");
        this.assertToAndFromSphericalGeography("MULTIPOLYGON EMPTY");
        this.assertToAndFromSphericalGeography("GEOMETRYCOLLECTION EMPTY");
        this.assertToAndFromSphericalGeography("POINT (-40.2 28.9)");
        this.assertToAndFromSphericalGeography("MULTIPOINT ((-40.2 28.9), (-40.2 31.9))");
        this.assertToAndFromSphericalGeography("LINESTRING (-40.2 28.9, -40.2 31.9, -37.2 31.9)");
        this.assertToAndFromSphericalGeography("MULTILINESTRING ((-40.2 28.9, -40.2 31.9), (-40.2 31.9, -37.2 31.9))");
        this.assertToAndFromSphericalGeography("POLYGON ((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9))");
        this.assertToAndFromSphericalGeography("POLYGON ((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9), (-39.2 29.9, -39.2 30.9, -38.2 30.9, -38.2 29.9, -39.2 29.9))");
        this.assertToAndFromSphericalGeography("MULTIPOLYGON (((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9)), ((-39.2 29.9, -38.2 29.9, -38.2 30.9, -39.2 30.9, -39.2 29.9)))");
        this.assertToAndFromSphericalGeography("GEOMETRYCOLLECTION (POINT (-40.2 28.9), LINESTRING (-40.2 28.9, -40.2 31.9, -37.2 31.9), POLYGON ((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9)))");
        this.assertInvalidLongitude("POINT (-340.2 28.9)");
        this.assertInvalidLatitude("MULTIPOINT ((-40.2 128.9), (-40.2 31.9))");
        this.assertInvalidLongitude("LINESTRING (-40.2 28.9, -40.2 31.9, 237.2 31.9)");
        this.assertInvalidLatitude("MULTILINESTRING ((-40.2 28.9, -40.2 31.9), (-40.2 131.9, -37.2 31.9))");
        this.assertInvalidLongitude("POLYGON ((-40.2 28.9, -40.2 31.9, 237.2 31.9, -37.2 28.9, -40.2 28.9))");
        this.assertInvalidLatitude("POLYGON ((-40.2 28.9, -40.2 31.9, -37.2 131.9, -37.2 28.9, -40.2 28.9), (-39.2 29.9, -39.2 30.9, -38.2 30.9, -38.2 29.9, -39.2 29.9))");
        this.assertInvalidLongitude("MULTIPOLYGON (((-40.2 28.9, -40.2 31.9, -37.2 31.9, -37.2 28.9, -40.2 28.9)), ((-39.2 29.9, -39.2 30.9, 238.2 30.9, -38.2 29.9, -39.2 29.9)))");
        this.assertInvalidLatitude("GEOMETRYCOLLECTION (POINT (-40.2 28.9), LINESTRING (-40.2 28.9, -40.2 131.9, -37.2 31.9), POLYGON ((-40.2 28.9, -40.2 31.9, -37.2 31.9, -37.2 28.9, -40.2 28.9)))");
    }

    private void assertToAndFromSphericalGeography(String wkt) {
        this.assertFunction(String.format("ST_AsText(to_geometry(to_spherical_geography(ST_GeometryFromText('%s'))))", wkt), (Type)VarcharType.VARCHAR, wkt);
    }

    private void assertInvalidLongitude(String wkt) {
        this.assertInvalidFunction(String.format("to_spherical_geography(ST_GeometryFromText('%s'))", wkt), "Longitude must be between -180 and 180");
    }

    private void assertInvalidLatitude(String wkt) {
        this.assertInvalidFunction(String.format("to_spherical_geography(ST_GeometryFromText('%s'))", wkt), "Latitude must be between -90 and 90");
    }

    @Test
    public void testDistance() {
        this.assertDistance("POINT (-86.67 36.12)", "POINT (-118.40 33.94)", 2886448.9734367016);
        this.assertDistance("POINT (-118.40 33.94)", "POINT (-86.67 36.12)", 2886448.9734367016);
        this.assertDistance("POINT (-71.0589 42.3601)", "POINT (-71.2290 42.4430)", 16734.69743457383);
        this.assertDistance("POINT (-86.67 36.12)", "POINT (-86.67 36.12)", 0.0);
        this.assertDistance("POINT EMPTY", "POINT (40 30)", null);
        this.assertDistance("POINT (20 10)", "POINT EMPTY", null);
        this.assertDistance("POINT EMPTY", "POINT EMPTY", null);
    }

    private void assertDistance(String wkt, String otherWkt, Double expectedDistance) {
        this.assertFunction(String.format("ST_Distance(to_spherical_geography(ST_GeometryFromText('%s')), to_spherical_geography(ST_GeometryFromText('%s')))", wkt, otherWkt), (Type)DoubleType.DOUBLE, expectedDistance);
    }

    @Test
    public void testArea() throws Exception {
        Map<String, Double> stateAreas;
        Map<String, String> stateGeometries;
        this.assertFunction("ST_Area(to_spherical_geography(ST_GeometryFromText('POLYGON EMPTY')))", (Type)DoubleType.DOUBLE, null);
        this.assertInvalidFunction("ST_Area(to_spherical_geography(ST_GeometryFromText('POLYGON((90 0, 0 0))')))", "Polygon is not valid: a loop contains less then 3 vertices.");
        this.assertInvalidFunction("ST_Area(to_spherical_geography(ST_GeometryFromText('POINT (0 1)')))", "When applied to SphericalGeography inputs, ST_Area only supports POLYGON or MULTI_POLYGON. Input type is: POINT");
        this.assertInvalidFunction("ST_Area(to_spherical_geography(ST_GeometryFromText('POLYGON((0 0, 0 1, 1 1, 1 1, 1 0, 0 0))')))", "Polygon is not valid: it has two identical consecutive vertices");
        this.assertArea("POLYGON((-135 85, -45 85, 45 85, 135 85, -135 85))", 6.19E11);
        this.assertArea("POLYGON((0 0, 0 1, 1 1, 1 0))", 1.2364E10);
        this.assertArea("POLYGON((-122.150124 37.486095, -122.149201 37.486606,  -122.145725 37.486580, -122.145923 37.483961 , -122.149324 37.482480 ,  -122.150837 37.483238,  -122.150901 37.485392))", 163290.93943446054);
        double angleOfOneKm = 0.008993201943349;
        this.assertArea(String.format("POLYGON((0 0, %.15f 0, %.15f %.15f, 0 %.15f))", angleOfOneKm, angleOfOneKm, angleOfOneKm, angleOfOneKm), 1000000.0);
        this.assertArea("POLYGON((90 0, 0 0, 0 90))", 6.3758E13);
        this.assertArea("POLYGON((90 0, 0 0, 0 90), (89 1, 1 1, 1 89))", 3.4804E12);
        Path geometryPath = new File(Resources.getResource((String)"us-states.tsv").toURI()).toPath();
        try (Stream<String> lines = Files.lines(geometryPath);){
            stateGeometries = lines.map(line -> line.split("\t")).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1]));
        }
        Path areaPath = new File(Resources.getResource((String)"us-state-areas.tsv").toURI()).toPath();
        try (Stream<String> lines = Files.lines(areaPath);){
            stateAreas = lines.map(line -> line.split("\t")).filter(parts -> ((String[])parts).length >= 2).collect(Collectors.toMap(parts -> parts[0], parts -> Double.valueOf(parts[1])));
        }
        for (String state : stateGeometries.keySet()) {
            this.assertArea(stateGeometries.get(state), stateAreas.get(state));
        }
    }

    private void assertArea(String wkt, double expectedArea) {
        this.assertFunction(String.format("ABS(ROUND((ST_Area(to_spherical_geography(ST_GeometryFromText('%s'))) / %f - 1 ) * %d, 0))", wkt, expectedArea, 10000), (Type)DoubleType.DOUBLE, 0.0);
    }
}

