/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import io.trino.block.BlockAssertions;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.spi.Page;
import io.trino.spi.Plugin;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.testng.annotations.BeforeClass;

public abstract class AbstractTestGeoAggregationFunctions
extends AbstractTestFunctions {
    @BeforeClass
    public void registerFunctions() {
        this.functionAssertions.installPlugin((Plugin)new GeoPlugin());
    }

    protected void assertAggregatedGeometries(String testDescription, String expectedWkt, String ... wkts) {
        List geometrySlices = Arrays.stream(wkts).map(text -> text == null ? null : OGCGeometry.fromText((String)text)).map(input -> input == null ? null : GeometrySerde.serialize((OGCGeometry)input)).collect(Collectors.toList());
        BiFunction<Object, Object, Boolean> equalityFunction = (left, right) -> {
            OGCGeometry rightGeometry;
            if (left == null && right == null) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            OGCGeometry leftGeometry = OGCGeometry.fromText((String)left.toString());
            return leftGeometry.difference(rightGeometry = OGCGeometry.fromText((String)right.toString())).isEmpty() && rightGeometry.difference(leftGeometry).isEmpty();
        };
        AggregationTestUtils.assertAggregation((TestingFunctionResolution)this.functionAssertions.getFunctionResolution(), (QualifiedName)QualifiedName.of((String)this.getFunctionName()), (List)TypeSignatureProvider.fromTypes((Type[])new Type[]{GeometryType.GEOMETRY}), equalityFunction, (String)testDescription, (Page)new Page(new Block[]{BlockAssertions.createSlicesBlock(geometrySlices)}), (Object)expectedWkt);
        Collections.reverse(geometrySlices);
        AggregationTestUtils.assertAggregation((TestingFunctionResolution)this.functionAssertions.getFunctionResolution(), (QualifiedName)QualifiedName.of((String)this.getFunctionName()), (List)TypeSignatureProvider.fromTypes((Type[])new Type[]{GeometryType.GEOMETRY}), equalityFunction, (String)testDescription, (Page)new Page(new Block[]{BlockAssertions.createSlicesBlock(geometrySlices)}), (Object)expectedWkt);
    }

    protected abstract String getFunctionName();
}

