/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import io.trino.plugin.geospatial.aggregation.GeometryState;
import io.trino.plugin.geospatial.aggregation.GeometryStateFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGeometryStateFactory {
    private final GeometryStateFactory factory = new GeometryStateFactory();

    @Test
    public void testCreateSingleStateEmpty() {
        GeometryState state = this.factory.createSingleState();
        Assert.assertNull((Object)state.getGeometry());
        Assert.assertEquals((long)0L, (long)state.getEstimatedSize());
    }

    @Test
    public void testCreateSingleStatePresent() {
        GeometryState state = this.factory.createSingleState();
        state.setGeometry(OGCGeometry.fromText((String)"POINT (1 2)"));
        Assert.assertEquals((Object)OGCGeometry.fromText((String)"POINT (1 2)"), (Object)state.getGeometry());
        Assert.assertTrue((state.getEstimatedSize() > 0L ? 1 : 0) != 0, (String)("Estimated memory size was " + state.getEstimatedSize()));
    }

    @Test
    public void testCreateGroupedStateEmpty() {
        GeometryState state = this.factory.createGroupedState();
        Assert.assertNull((Object)state.getGeometry());
        Assert.assertTrue((state.getEstimatedSize() > 0L ? 1 : 0) != 0, (String)("Estimated memory size was " + state.getEstimatedSize()));
    }

    @Test
    public void testCreateGroupedStatePresent() {
        GeometryState state = this.factory.createGroupedState();
        Assert.assertNull((Object)state.getGeometry());
        Assert.assertTrue((boolean)(state instanceof GeometryStateFactory.GroupedGeometryState));
        GeometryStateFactory.GroupedGeometryState groupedState = (GeometryStateFactory.GroupedGeometryState)state;
        groupedState.setGroupId(1L);
        Assert.assertNull((Object)state.getGeometry());
        groupedState.setGeometry(OGCGeometry.fromText((String)"POINT (1 2)"));
        Assert.assertEquals((Object)state.getGeometry(), (Object)OGCGeometry.fromText((String)"POINT (1 2)"));
        groupedState.setGroupId(2L);
        Assert.assertNull((Object)state.getGeometry());
        groupedState.setGeometry(OGCGeometry.fromText((String)"POINT (3 4)"));
        Assert.assertEquals((Object)state.getGeometry(), (Object)OGCGeometry.fromText((String)"POINT (3 4)"));
        groupedState.setGroupId(1L);
        Assert.assertNotNull((Object)state.getGeometry());
    }
}

